/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldHelper {
    public static final <T> Optional<T> getBlock(IBlockAccess world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_180495_p(pos)).map(s -> s.func_177230_c()).filter(b -> type.isAssignableFrom(b.getClass())).map(b -> type.cast(b));
    }

    public static final <T> Optional<T> getTile(IBlockAccess world, BlockPos pos, Class<T> type) {
        return Optional.ofNullable(world).map(w -> w.func_175625_s(pos)).filter(te -> type.isAssignableFrom(te.getClass())).map(te -> type.cast(te));
    }

    public static final <T> List<T> getTileNeighbors(World world, BlockPos pos, Class<T> type) {
        return WorldHelper.getTileNeighbors(world, pos, type, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST);
    }

    public static final <T> List<T> getTileNeighbors(World world, BlockPos pos, Class<T> type, EnumFacing ... dirs) {
        ArrayList<T> neighbours = new ArrayList<T>();
        for (EnumFacing dir : dirs) {
            TileEntity te = world.func_175625_s(pos.func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()));
            if (te == null || !type.isAssignableFrom(te.getClass())) continue;
            neighbours.add(type.cast(te));
        }
        return neighbours;
    }
}

