/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.TessellatorAbstractBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TessellatorVertexBuffer
extends TessellatorAbstractBase {
    private static final Map<VertexBuffer, ThreadLocal<TessellatorVertexBuffer>> instances = new HashMap<VertexBuffer, ThreadLocal<TessellatorVertexBuffer>>();
    private final Tessellator tessellator;
    private final VertexBuffer buffer;

    private TessellatorVertexBuffer(VertexBuffer buffer, Tessellator tessellator) {
        this.buffer = buffer;
        this.tessellator = tessellator;
    }

    public static TessellatorVertexBuffer getInstance() {
        return TessellatorVertexBuffer.getInstance(Tessellator.func_178181_a());
    }

    public static TessellatorVertexBuffer getInstance(Tessellator tessellator) {
        return TessellatorVertexBuffer.getInstance(tessellator.func_178180_c(), tessellator);
    }

    public static TessellatorVertexBuffer getInstance(VertexBuffer buffer) {
        return TessellatorVertexBuffer.getInstance(buffer, null);
    }

    private static TessellatorVertexBuffer getInstance(VertexBuffer buffer, Tessellator tessellator) {
        ThreadLocal<TessellatorVertexBuffer> threadLocal;
        TessellatorVertexBuffer tess;
        if (!instances.containsKey(buffer)) {
            instances.put(buffer, new ThreadLocal());
        }
        if ((tess = (threadLocal = instances.get(buffer)).get()) == null) {
            tess = new TessellatorVertexBuffer(buffer, tessellator);
            threadLocal.set(tess);
        }
        return tess;
    }

    public VertexBuffer getVertexBuffer() {
        return this.buffer;
    }

    @Override
    protected void onStartDrawingQuadsCall() {
        this.buffer.func_181668_a(7, this.getVertexFormat());
    }

    @Override
    public List<BakedQuad> getQuads() {
        return ImmutableList.of();
    }

    @Override
    protected void onDrawCall() {
        if (this.tessellator != null) {
            this.tessellator.func_78381_a();
        } else {
            this.buffer.func_178977_d();
        }
    }

    @Override
    public void addQuads(List<BakedQuad> quads) {
        for (BakedQuad quad : quads) {
            this.buffer.func_178981_a(this.transformQuad(quad).func_178209_a());
        }
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, float u, float v) {
        double[] coords = this.getTransformationMatrix().transform(x, y, z);
        this.buffer.func_181662_b(coords[0], coords[1], coords[2]);
        this.buffer.func_181669_b(this.getRedValueInt(), this.getGreenValueInt(), this.getBlueValueInt(), this.getAlphaValueInt());
        this.buffer.func_187315_a((double)u, (double)v);
        this.buffer.func_187314_a(this.getBrightness() >> 16 & 0xFFFF, this.getBrightness() & 0xFFFF);
        this.buffer.func_181675_d();
    }

    private TessellatorVertexBuffer reset() {
        this.resetMatrix();
        this.setColorRGBA(255, 255, 255, 255);
        this.setBrightness(0xF000000);
        return this;
    }

    @Override
    protected void applyColorMultiplier(EnumFacing side) {
        float preMultiplier = this.getMultiplier(this.transformSide(side));
        float r = preMultiplier * ((float)this.getRedValueInt() / 255.0f);
        float g = preMultiplier * ((float)this.getGreenValueInt() / 255.0f);
        float b = preMultiplier * ((float)this.getBlueValueInt() / 255.0f);
        this.setColorRGB_F(r, g, b);
    }

    private EnumFacing transformSide(EnumFacing dir) {
        if (dir == null) {
            return null;
        }
        double[] coords = this.getTransformationMatrix().transform(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
        double[] translation = this.getTransformationMatrix().getTranslation();
        coords[0] = coords[0] - translation[0];
        coords[1] = coords[1] - translation[1];
        coords[2] = coords[2] - translation[2];
        double x = Math.abs(coords[0]);
        double y = Math.abs(coords[1]);
        double z = Math.abs(coords[2]);
        if (x > z) {
            if (x > y) {
                return coords[0] > 0.0 ? EnumFacing.EAST : EnumFacing.WEST;
            }
        } else if (z > y) {
            return coords[2] > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return coords[1] > 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
    }

    private float getMultiplier(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case EAST: 
            case WEST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }
}

