/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.utility.math.TransformationMatrix;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class TessellatorAbstractBase
implements ITessellator {
    public static final int STANDARD_COLOR = 255;
    public static final int STANDARD_BRIGHTNESS = 0xF000000;
    public static final Vector3f STANDARD_NORMAL = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Deque<TransformationMatrix> matrices = new ArrayDeque<TransformationMatrix>();
    private VertexFormat format;
    private Vector3f normal = STANDARD_NORMAL;
    private int r;
    private int g;
    private int b;
    private int a;
    private int l;
    private int tintIndex = -1;
    private boolean applyDiffuseLighting = false;

    protected TessellatorAbstractBase() {
        this.resetMatrix();
    }

    @Override
    public final void startDrawingQuads(VertexFormat vertexFormat) {
        this.format = vertexFormat;
        this.onStartDrawingQuadsCall();
    }

    protected abstract void onStartDrawingQuadsCall();

    @Override
    public final void draw() {
        this.onDrawCall();
        this.format = null;
        this.normal = STANDARD_NORMAL;
        this.setColorRGBA(255, 255, 255, 255);
        this.setBrightness(0xF000000);
        this.tintIndex = -1;
        this.applyDiffuseLighting = false;
        this.resetMatrix();
    }

    protected abstract void onDrawCall();

    @Override
    public final VertexFormat getVertexFormat() {
        return this.format;
    }

    @Override
    public void pushMatrix() {
        this.matrices.push(new TransformationMatrix(this.matrices.getFirst()));
    }

    @Override
    public void popMatrix() {
        if (this.matrices.size() <= 1) {
            throw new IndexOutOfBoundsException("No matrix to pop!");
        }
        this.matrices.pop();
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        if (icon == null) {
            icon = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        this.addVertexWithUV(x, y, z, icon.func_94214_a((double)u), icon.func_94207_b((double)v));
    }

    @Override
    public void addScaledVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        this.addVertexWithUV(x * 0.0625f, y * 0.0625f, z * 0.0625f, icon, u, v);
    }

    @Override
    public void drawScaledFace(float minX, float minY, float maxX, float maxY, EnumFacing face, TextureAtlasSprite icon, float offset) {
        float v1;
        float v2;
        float v3;
        float v4;
        float u1;
        float u4;
        float u2;
        float u3;
        float y1;
        float y2;
        float y3;
        float y4;
        float z3;
        float z4;
        float z1;
        float z2;
        float x2;
        float x3;
        float x1;
        float x4;
        int uv = 17;
        switch (face) {
            case UP: {
                x1 = x4 = maxX;
                x2 = x3 = minX;
                z1 = z2 = minY;
                z3 = z4 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u2 = u3 = minX % 17.0f;
                u1 = u4 = maxX % 17.0f;
                v3 = v4 = maxY % 17.0f;
                v1 = v2 = minY % 17.0f;
                break;
            }
            case DOWN: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                z1 = z4 = minY;
                z2 = z3 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case WEST: {
                z1 = z2 = maxX;
                z3 = z4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case EAST: {
                z1 = z2 = minX;
                z3 = z4 = maxX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1 = u2 = 16.0f - minX % 17.0f;
                u3 = u4 = 16.0f - maxX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case NORTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = maxY;
                y2 = y3 = minY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1 = u2 = 16.0f - maxX % 17.0f;
                u3 = u4 = 16.0f - minX % 17.0f;
                v1 = v4 = 16.0f - maxY % 17.0f;
                v2 = v3 = 16.0f - minY % 17.0f;
                break;
            }
            case SOUTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            default: {
                return;
            }
        }
        int rPrev = this.r;
        int gPrev = this.g;
        int bPrev = this.b;
        int aPrev = this.a;
        this.applyColorMultiplier(face);
        this.setNormal(new Vector3f((float)face.func_82601_c(), (float)face.func_96559_d(), (float)face.func_82599_e()));
        this.addScaledVertexWithUV(x1, y1, z1, icon, u1, v1);
        this.addScaledVertexWithUV(x2, y2, z2, icon, u2, v2);
        this.addScaledVertexWithUV(x3, y3, z3, icon, u3, v3);
        this.addScaledVertexWithUV(x4, y4, z4, icon, u4, v4);
        this.setColorRGBA(rPrev, gPrev, bPrev, aPrev);
    }

    @Override
    public void drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, EnumFacing face, TextureAtlasSprite icon, float offset) {
        EnumFacing opposite;
        switch (face) {
            case NORTH: {
                opposite = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                opposite = EnumFacing.NORTH;
                break;
            }
            case EAST: {
                opposite = EnumFacing.WEST;
                break;
            }
            case WEST: {
                opposite = EnumFacing.EAST;
                break;
            }
            case UP: {
                opposite = EnumFacing.DOWN;
                break;
            }
            case DOWN: {
                opposite = EnumFacing.UP;
                break;
            }
            default: {
                return;
            }
        }
        this.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, icon, offset);
    }

    @Override
    public void drawScaledPrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite icon) {
        this.drawScaledFace(minX, minZ, maxX, maxZ, EnumFacing.DOWN, icon, minY);
        this.drawScaledFace(minX, minZ, maxX, maxZ, EnumFacing.UP, icon, maxY);
        this.drawScaledFace(minX, minY, maxX, maxY, EnumFacing.NORTH, icon, minZ);
        this.drawScaledFace(minX, minY, maxX, maxY, EnumFacing.SOUTH, icon, maxZ);
        this.drawScaledFace(minZ, minY, maxZ, maxY, EnumFacing.WEST, icon, minX);
        this.drawScaledFace(minZ, minY, maxZ, maxY, EnumFacing.EAST, icon, maxX);
    }

    @Override
    public TessellatorAbstractBase setTranslation(double x, double y, double z) {
        this.matrices.getFirst().setTranslation(x, y, z);
        return this;
    }

    @Override
    public TessellatorAbstractBase setRotation(double angle, double x, double y, double z) {
        this.matrices.getFirst().setRotation(angle, x, y, z);
        return this;
    }

    @Override
    public TessellatorAbstractBase translate(BlockPos pos) {
        this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this;
    }

    @Override
    public TessellatorAbstractBase translate(double x, double y, double z) {
        this.matrices.getFirst().multiplyRightWith(new TransformationMatrix(x, y, z));
        return this;
    }

    @Override
    public TessellatorAbstractBase rotate(double angle, double x, double y, double z) {
        this.matrices.getFirst().multiplyRightWith(new TransformationMatrix(angle, x, y, z));
        return this;
    }

    @Override
    public TessellatorAbstractBase scale(double x, double y, double z) {
        this.matrices.getFirst().scale(x, y, z);
        return this;
    }

    public TessellatorAbstractBase applyTransformation(TransformationMatrix transformationMatrix) {
        this.matrices.getFirst().multiplyRightWith(transformationMatrix);
        return this;
    }

    public TransformationMatrix getTransformationMatrix() {
        return this.matrices.getFirst();
    }

    public TessellatorAbstractBase resetMatrix() {
        this.matrices.clear();
        this.matrices.push(new TransformationMatrix());
        return this;
    }

    @Override
    public TextureAtlasSprite getIcon(ResourceLocation loc) {
        if (loc != null) {
            return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply((Object)loc);
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @Override
    public TessellatorAbstractBase bindTexture(ResourceLocation loc) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(loc);
        return this;
    }

    @Override
    public TessellatorAbstractBase setNormal(float x, float y, float z) {
        return this.setNormal(new Vector3f(x, y, z));
    }

    @Override
    public TessellatorAbstractBase setNormal(Vector3f vec) {
        this.normal = vec == null ? this.normal : vec;
        return this;
    }

    @Override
    public Vector3f getNormal() {
        return this.normal;
    }

    @Override
    public TessellatorAbstractBase setColor(int color) {
        this.setColorTransparent(color);
        this.a = 255;
        return this;
    }

    @Override
    public TessellatorAbstractBase setColorTransparent(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = this.a;
        return this.setColorRGBA(red, green, blue, alpha);
    }

    @Override
    public int getColor() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public TessellatorAbstractBase setColorRGB_F(float red, float green, float blue) {
        return this.setColorRGBA_F(red, green, blue, 1.0f);
    }

    @Override
    public TessellatorAbstractBase setColorRGBA_F(float red, float green, float blue, float alpha) {
        return this.setColorRGBA((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    @Override
    public TessellatorAbstractBase setColorRGB(int red, int green, int blue) {
        return this.setColorRGBA(red, green, blue, 255);
    }

    @Override
    public TessellatorAbstractBase setColorRGBA(int red, int green, int blue, int alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
        return this;
    }

    @Override
    public float getRedValueFloat() {
        return (float)this.getRedValueInt() / 255.0f;
    }

    @Override
    public float getGreenValueFloat() {
        return (float)this.getGreenValueInt() / 255.0f;
    }

    @Override
    public float getBlueValueFloat() {
        return (float)this.getBlueValueInt() / 255.0f;
    }

    @Override
    public float getAlphaValueFloat() {
        return (float)this.getAlphaValueInt() / 255.0f;
    }

    @Override
    public int getRedValueInt() {
        return this.r;
    }

    @Override
    public int getGreenValueInt() {
        return this.g;
    }

    @Override
    public int getBlueValueInt() {
        return this.b;
    }

    @Override
    public int getAlphaValueInt() {
        return this.a;
    }

    @Override
    public TessellatorAbstractBase setBrightness(int value) {
        this.l = value;
        return this;
    }

    @Override
    public int getBrightness() {
        return this.l;
    }

    @Override
    public TessellatorAbstractBase setTintIndex(int index) {
        this.tintIndex = index;
        return this;
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex;
    }

    @Override
    public TessellatorAbstractBase setApplyDiffuseLighting(boolean value) {
        this.applyDiffuseLighting = value;
        return this;
    }

    @Override
    public boolean getApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    protected abstract void applyColorMultiplier(EnumFacing var1);

    protected UnpackedBakedQuad transformQuad(BakedQuad quad) {
        VertexFormat format = quad.getFormat();
        float[][][] vertexData = new float[4][format.func_177345_h()][];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < format.func_177345_h(); ++e) {
                float[] data = new float[4];
                LightUtil.unpack((int[])quad.func_178209_a(), (float[])data, (VertexFormat)format, (int)v, (int)e);
                vertexData[v][e] = this.transformUnpackedVertexDataElement(format.func_177348_c(e).func_177375_c(), data);
            }
        }
        return new UnpackedBakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), this.getApplyDiffuseLighting(), format);
    }

    protected float[] transformUnpackedVertexDataElement(VertexFormatElement.EnumUsage type, float[] data) {
        switch (type) {
            case POSITION: 
            case NORMAL: {
                double[] pos = this.getTransformationMatrix().transform(data[0], data[1], data[2]);
                data[0] = (float)pos[0];
                data[1] = (float)pos[1];
                data[2] = (float)pos[2];
                break;
            }
            case COLOR: {
                data[0] = this.getRedValueFloat();
                data[1] = this.getGreenValueFloat();
                data[2] = this.getBlueValueFloat();
                data[3] = this.getAlphaValueFloat();
            }
        }
        return data;
    }
}

