/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.model;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.render.tessellation.VertexData;
import com.infinityraider.infinitylib.utility.math.TransformationMatrix;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelTechne<M extends ModelBase> {
    private final M model;
    private final List<ModelRenderer> modelRenderers;
    private final List<Tuple<ModelRenderer, List<TexturedQuad>>> texturedQuads;
    private boolean diffuseLighting;

    public ModelTechne(M techneModel) {
        this.model = techneModel;
        this.modelRenderers = ModelTechne.compileModelRendererList(this.getModel());
        this.texturedQuads = ModelTechne.compileTexturedQuadList(this.getModelRenderers());
    }

    public ModelTechne<M> setDiffuseLighting(boolean status) {
        this.diffuseLighting = status;
        return this;
    }

    public boolean getDiffuseLighting() {
        return this.diffuseLighting;
    }

    public M getModel() {
        return this.model;
    }

    public List<ModelRenderer> getModelRenderers() {
        return this.modelRenderers;
    }

    public List<Tuple<ModelRenderer, List<TexturedQuad>>> getTexturedQuads() {
        return this.texturedQuads;
    }

    public List<BakedQuad> getBakedQuads(VertexFormat format, TextureAtlasSprite icon, double scale) {
        if (icon == null) {
            return this.getBakedQuads(format, scale);
        }
        ArrayList list = new ArrayList();
        for (Tuple<ModelRenderer, List<TexturedQuad>> tuple : this.getTexturedQuads()) {
            list.addAll(((List)tuple.func_76340_b()).stream().map(quad -> this.createBakedQuad(format, scale * 0.0625, (ModelRenderer)tuple.func_76341_a(), (TexturedQuad)quad, icon)).collect(Collectors.toList()));
        }
        return ImmutableList.copyOf(list);
    }

    private BakedQuad createBakedQuad(VertexFormat format, double scale, ModelRenderer renderer, TexturedQuad quad, TextureAtlasSprite icon) {
        TransformationMatrix matrix = ModelTechne.getTransformationMatrixForRenderer(renderer, scale);
        Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
        Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
        Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        double[] normal = matrix.transform(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c);
        VertexData[] vertexData = new VertexData[quad.field_78239_a.length];
        for (int i = 0; i < vertexData.length; ++i) {
            PositionTextureVertex vertex = quad.field_78239_a[i];
            double[] pos = matrix.transform(vertex.field_78243_a.field_72450_a * scale, vertex.field_78243_a.field_72448_b * scale, vertex.field_78243_a.field_72449_c * scale);
            vertexData[i] = new VertexData(format, (float)pos[0], (float)pos[1], (float)pos[2], icon.func_94214_a((double)(vertex.field_78241_b * 16.0f)), icon.func_94207_b((double)(vertex.field_78242_c * 16.0f)));
            vertexData[i].setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
            vertexData[i].setNormal((float)normal[0], (float)normal[1], (float)normal[2]);
        }
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(format);
        quadBuilder.setTexture(icon);
        quadBuilder.setApplyDiffuseLighting(this.getDiffuseLighting());
        for (VertexData data : vertexData) {
            data.applyVertexData(quadBuilder);
        }
        return quadBuilder.build();
    }

    public List<BakedQuad> getBakedQuads(VertexFormat format, double scale) {
        ArrayList list = new ArrayList();
        for (Tuple<ModelRenderer, List<TexturedQuad>> tuple : this.getTexturedQuads()) {
            list.addAll(((List)tuple.func_76340_b()).stream().map(quad -> ModelTechne.createBakedQuad(format, scale * 0.0625, (ModelRenderer)tuple.func_76341_a(), quad)).collect(Collectors.toList()));
        }
        return ImmutableList.copyOf(list);
    }

    private static List<ModelRenderer> compileModelRendererList(ModelBase model) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (Field field : model.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(ModelRenderer.class)) continue;
            field.setAccessible(true);
            try {
                list.add((ModelRenderer)field.get(model));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ImmutableList.copyOf(list);
    }

    private static List<Tuple<ModelRenderer, List<TexturedQuad>>> compileTexturedQuadList(List<ModelRenderer> modelRenderers) {
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (ModelRenderer model : modelRenderers) {
            ArrayList quadList = new ArrayList();
            for (ModelBox box : model.field_78804_l) {
                Field fieldQuads = null;
                for (Field field : box.getClass().getDeclaredFields()) {
                    if (!field.getType().isAssignableFrom(TexturedQuad[].class)) continue;
                    fieldQuads = field;
                    break;
                }
                if (fieldQuads == null) continue;
                fieldQuads.setAccessible(true);
                try {
                    Collections.addAll(quadList, (TexturedQuad[])fieldQuads.get(box));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            list.add(new Tuple((Object)model, (Object)ImmutableList.copyOf(quadList)));
        }
        return ImmutableList.copyOf(list);
    }

    private static BakedQuad createBakedQuad(VertexFormat format, double scale, ModelRenderer renderer, TexturedQuad quad) {
        TransformationMatrix matrix = ModelTechne.getTransformationMatrixForRenderer(renderer, scale);
        Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
        Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
        Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        double[] normal = matrix.transform(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c);
        VertexData[] vertexData = new VertexData[quad.field_78239_a.length];
        for (int i = 0; i < vertexData.length; ++i) {
            PositionTextureVertex vertex = quad.field_78239_a[i];
            double[] pos = matrix.transform(vertex.field_78243_a.field_72450_a * scale, vertex.field_78243_a.field_72448_b * scale, vertex.field_78243_a.field_72449_c * scale);
            vertexData[i] = new VertexData(format, (float)pos[0], (float)pos[1], (float)pos[2], vertex.field_78241_b, vertex.field_78242_c);
            vertexData[i].setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
            vertexData[i].setNormal((float)normal[0], (float)normal[1], (float)normal[2]);
        }
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(format);
        for (VertexData data : vertexData) {
            data.applyVertexData(quadBuilder);
        }
        return quadBuilder.build();
    }

    private static TransformationMatrix getTransformationMatrixForRenderer(ModelRenderer renderer, double scale) {
        TransformationMatrix matrix = new TransformationMatrix(180.0, 1.0, 0.0, 0.0);
        matrix.multiplyRightWith(new TransformationMatrix(8.0 * scale, -24.0 * scale, -8.0 * scale));
        matrix.multiplyRightWith(new TransformationMatrix((double)renderer.field_82906_o + (double)renderer.field_78800_c * scale, (double)renderer.field_82908_p + (double)renderer.field_78797_d * scale, (double)renderer.field_82907_q + (double)renderer.field_78798_e * scale));
        if (renderer.field_78808_h != 0.0f) {
            matrix.multiplyRightWith(new TransformationMatrix(renderer.field_78808_h * 57.295776f, 0.0, 0.0, 1.0));
        }
        if (renderer.field_78796_g != 0.0f) {
            matrix.multiplyRightWith(new TransformationMatrix(renderer.field_78796_g * 57.295776f, 0.0, 1.0, 0.0));
        }
        if (renderer.field_78795_f != 0.0f) {
            matrix.multiplyRightWith(new TransformationMatrix(renderer.field_78795_f * 57.295776f, 1.0, 0.0, 0.0));
        }
        return matrix;
    }
}

