/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.NetworkWrapper;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import com.infinityraider.infinitylib.utility.InfinityLogger;
import com.infinityraider.infinitylib.utility.ModEventHandlerHack;
import com.infinityraider.infinitylib.utility.ModHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;

public abstract class InfinityMod {
    private final InfinityLogger logger = new InfinityLogger(this);
    private final INetworkWrapper networkWrapper = new NetworkWrapper(this);

    public InfinityMod() {
        ModEventHandlerHack.doHack(this);
    }

    public final InfinityLogger getLogger() {
        return this.logger;
    }

    public final INetworkWrapper getNetworkWrapper() {
        return this.networkWrapper;
    }

    public abstract IProxyBase proxy();

    public abstract String getModId();

    public abstract Object getModBlockRegistry();

    public abstract Object getModItemRegistry();

    public abstract Object getModEntityRegistry();

    public abstract void registerMessages(INetworkWrapper var1);

    @Mod.EventHandler
    public final void preInit(FMLPreInitializationEvent event) {
        this.getLogger().debug("Starting Pre-Initialization", new Object[0]);
        this.proxy().initConfiguration(event);
        this.proxy().preInitStart(event);
        this.proxy().activateRequiredModules();
        ModHelper.getInstance().RegisterBlocksAndItems(this);
        InfinityLib.proxy.registerRenderers(this);
        InfinityLib.proxy.registerEntities(this);
        this.proxy().preInitEnd(event);
        this.getLogger().debug("Pre-Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void init(FMLInitializationEvent event) {
        this.getLogger().debug("Starting Initialization", new Object[0]);
        this.proxy().initStart(event);
        this.proxy().registerCapabilities();
        this.proxy().registerEventHandlers();
        this.registerMessages(this.getNetworkWrapper());
        ModHelper.getInstance().registerRecipes(this);
        this.proxy().initEnd(event);
        this.getLogger().debug("Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void postInit(FMLPostInitializationEvent event) {
        this.getLogger().debug("Starting Post-Initialization", new Object[0]);
        this.proxy().postInitStart(event);
        this.proxy().postInitEnd(event);
        this.getLogger().debug("Post-Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.proxy().onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public final void onServerStarting(FMLServerStartingEvent event) {
        this.proxy().onServerStarting(event);
    }

    @Mod.EventHandler
    public final void onServerStarted(FMLServerStartedEvent event) {
        this.proxy().onServerStarted(event);
    }

    @Mod.EventHandler
    public final void onServerStopping(FMLServerStoppingEvent event) {
        this.proxy().onServerStopping(event);
    }

    @Mod.EventHandler
    public final void onServerStopped(FMLServerStoppedEvent event) {
        this.proxy().onServerStopped(event);
    }

    public final Side getPhysicalSide() {
        return this.proxy().getPhysicalSide();
    }

    public final Side getEffectiveSide() {
        return this.proxy().getEffectiveSide();
    }

    public final MinecraftServer getMinecraftServer() {
        return this.proxy().getMinecraftServer();
    }

    public final EntityPlayer getClientPlayer() {
        return this.proxy().getClientPlayer();
    }

    public final World getClientWorld() {
        return this.proxy().getClientWorld();
    }

    public final World getWorldByDimensionId(int dimension) {
        return this.proxy().getWorldByDimensionId(dimension);
    }

    public final Entity getEntityById(int dimension, int id) {
        return this.proxy().getEntityById(dimension, id);
    }

    public final Entity getEntityById(World world, int id) {
        return this.proxy().getEntityById(world, id);
    }

    public final void queueTask(Runnable task) {
        this.proxy().queueTask(task);
    }
}

