/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import me.ichun.mods.ichunutil.client.core.event.EventHandlerClient;
import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.ProxyCommon;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import me.ichun.mods.ichunutil.common.core.event.EventHandlerServer;
import me.ichun.mods.ichunutil.common.core.network.PacketChannel;
import me.ichun.mods.ichunutil.common.core.util.ObfHelper;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ichunutil", name="iChunUtil", version="6.2.0", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:Forge@[12.18.2.2151,99999.19.0.0)", acceptableRemoteVersions="[6.2.0,6.3.0)", acceptedMinecraftVersions="[1.9.4,1.10.2]")
public class iChunUtil {
    public static final String VERSION_OF_MC = "1.10.2";
    public static final int VERSION_MAJOR = 6;
    public static final int VERSION_MINOR = 2;
    public static final String VERSION = "6.2.0";
    public static final String MOD_NAME = "iChunUtil";
    public static final String MOD_ID = "ichunutil";
    public static final int REQ_FORGE_MAJOR = 12;
    public static final int REQ_FORGE_MINOR = 18;
    public static final int REQ_FORGE_REVISION = 2;
    public static final int REQ_FORGE_BUILD = 2151;
    public static final Logger LOGGER = Logger.createLogger("iChunUtil");
    @Mod.Instance(value="ichunutil")
    public static iChunUtil instance;
    @SidedProxy(clientSide="me.ichun.mods.ichunutil.client.core.ProxyClient", serverSide="me.ichun.mods.ichunutil.common.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static Config config;
    public static PacketChannel channel;
    public static EventHandlerServer eventHandlerServer;
    public static EventHandlerClient eventHandlerClient;
    public static Block blockCompactPorkchop;
    public static List<ItemStack> oreDictBlockCompactRawPorkchop;
    private static boolean isCompactPorkchopRecipeAdded;
    private static boolean hasPostInit;
    private static boolean hasMorphMod;
    public static boolean userIsPatron;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        ObfHelper.detectObfuscation();
        config = ConfigHandler.registerConfig(new Config(event.getSuggestedConfigurationFile()));
        proxy.preInit();
        UpdateChecker.registerMod(new UpdateChecker.ModVersionInfo(MOD_NAME, VERSION_OF_MC, VERSION, false));
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        hasPostInit = true;
        hasMorphMod = Loader.isModLoaded((String)"Morph");
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        UpdateChecker.serverStarted();
        iChunUtil.setupCompactPorkchopRecipe();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        eventHandlerServer.shuttingDownServer();
    }

    public static void setupCompactPorkchopRecipe() {
        if (isCompactPorkchopRecipeAdded != (iChunUtil.config.enableCompactPorkchop == 1)) {
            if (isCompactPorkchopRecipeAdded) {
                ItemStack isPorkchop = new ItemStack(blockCompactPorkchop);
                List recipes = CraftingManager.func_77594_a().func_77592_b();
                recipes.removeIf(recipe -> recipe instanceof ShapedRecipes && ((ShapedRecipes)recipe).func_77571_b().func_77969_a(isPorkchop));
            } else {
                GameRegistry.addRecipe((ItemStack)new ItemStack(blockCompactPorkchop), (Object[])new Object[]{"PPP", "PPP", "PPP", Character.valueOf('P'), Items.field_151147_al});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151147_al, 9), (Object[])new Object[]{blockCompactPorkchop});
            }
            isCompactPorkchopRecipeAdded = iChunUtil.config.enableCompactPorkchop == 1;
        }
    }

    public static boolean hasPostInit() {
        return hasPostInit;
    }

    public static boolean hasMorphMod() {
        return hasMorphMod;
    }

    public class Config
    extends ConfigBase {
        @ConfigProp(category="clientOnly", side=Side.CLIENT, changeable=false)
        @IntBool
        public int enableStencils;
        @ConfigProp(category="block", useSession=true, module="compactPorkchop")
        @IntBool
        public int enableCompactPorkchop;
        @ConfigProp(module="eula")
        public String eulaAcknowledged;
        @ConfigProp(side=Side.CLIENT, module="patreon", hidden=true)
        @IntBool
        public int showPatronReward;
        @ConfigProp(side=Side.CLIENT, module="patreon", hidden=true)
        @IntMinMax(min=1, max=6)
        public int patronRewardType;
        @ConfigProp(module="versionCheck")
        @IntMinMax(min=0, max=2)
        public int versionNotificationTypes;
        @ConfigProp(side=Side.CLIENT, module="versionCheck")
        @IntMinMax(min=0, max=2)
        public int versionNotificationFrequency;
        @ConfigProp(side=Side.CLIENT, module="versionCheck")
        @IntMinMax(min=0, max=35)
        public int versionSave;

        public Config(File file) {
            super(file);
            this.enableStencils = 1;
            this.enableCompactPorkchop = 1;
            this.eulaAcknowledged = "";
            this.showPatronReward = 1;
            this.patronRewardType = 1;
            this.versionNotificationTypes = 0;
            this.versionNotificationFrequency = 2;
            this.versionSave = 0;
        }

        @Override
        public String getModId() {
            return iChunUtil.MOD_ID;
        }

        @Override
        public String getModName() {
            return iChunUtil.MOD_NAME;
        }

        @Override
        public void onReceiveSession() {
            List<ItemStack> compactPorkchops = oreDictBlockCompactRawPorkchop;
            if (compactPorkchops.size() == 1 && compactPorkchops.get(0).func_77973_b() != null && Block.func_149634_a((Item)compactPorkchops.get(0).func_77973_b()) == blockCompactPorkchop) {
                Minecraft.func_71410_x().func_152344_a(iChunUtil::setupCompactPorkchopRecipe);
            }
        }

        @Override
        public void onConfigChange(Field field, Object original) {
            if (field.getName().equals("showPatronReward") || field.getName().equals("patronRewardType")) {
                iChunUtil.eventHandlerClient.patronUpdateServerAsPatron = true;
            }
        }
    }
}

