/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.grab;

import java.util.ArrayList;
import java.util.EnumMap;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.grab.handlers.GrabbedEntityBlockHandler;
import me.ichun.mods.ichunutil.common.grab.handlers.GrabbedFallingBlockHandler;
import me.ichun.mods.ichunutil.common.grab.handlers.GrabbedFireballHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;

public class GrabHandler {
    public String identifier;
    public EntityLivingBase grabber;
    public Entity grabbed;
    public int grabberId;
    public int grabbedId;
    public float grabDistance;
    public float yawTweak;
    public float pitchTweak;
    public boolean forceTerminate;
    public int time;
    public static EnumMap<Side, ArrayList<GrabHandler>> grabbedEntities = new EnumMap<Side, ArrayList<GrabHandler>>(Side.class){
        {
            this.put(Side.SERVER, new ArrayList());
            this.put(Side.CLIENT, new ArrayList());
        }
    };
    public static ArrayList<Integer> dimensionalEntities = new ArrayList();
    private static ArrayList<GrabbedEntityHandler> entityHandlers = new ArrayList<GrabbedEntityHandler>(){
        {
            this.add(new GrabbedFireballHandler());
            this.add(new GrabbedFallingBlockHandler());
            this.add(new GrabbedEntityBlockHandler());
        }
    };

    public GrabHandler(EntityLivingBase grabber, Entity grabbed, float distance) {
        this.identifier = RandomStringUtils.randomAscii((int)20);
        this.grabber = grabber;
        this.grabbed = grabbed;
        this.grabberId = grabber.func_145782_y();
        this.grabbedId = grabbed.func_145782_y();
        this.grabDistance = distance;
    }

    public GrabHandler(String identifier, int grabberId, int grabbedId, float dist) {
        this.identifier = identifier;
        this.grabberId = grabberId;
        this.grabbedId = grabbedId;
        this.grabDistance = dist;
    }

    public void update() {
        ++this.time;
        Vec3d pos = EntityHelper.getEntityPositionEyes((Entity)this.grabber, 1.0f);
        this.grabber.field_70759_as += this.yawTweak;
        this.grabber.field_70125_A += this.pitchTweak;
        Vec3d look = this.grabber.func_70040_Z();
        this.grabber.field_70759_as -= this.yawTweak;
        this.grabber.field_70125_A -= this.pitchTweak;
        Vec3d grabPos = new Vec3d(pos.field_72450_a + look.field_72450_a * (double)this.grabDistance, pos.field_72448_b + look.field_72448_b * (double)this.grabDistance, pos.field_72449_c + look.field_72449_c * (double)this.grabDistance);
        float distTolerance = this.grabToleranceTillTeleport();
        if (distTolerance > 0.0f && this.grabbed.func_70011_f(grabPos.field_72450_a, grabPos.field_72448_b, grabPos.field_72449_c) > (double)distTolerance) {
            this.grabbed.field_70169_q = this.grabbed.field_70165_t = this.grabber.field_70165_t;
            this.grabbed.field_70142_S = this.grabbed.field_70165_t;
            this.grabbed.field_70167_r = this.grabbed.field_70163_u = this.grabber.field_70163_u;
            this.grabbed.field_70137_T = this.grabbed.field_70163_u;
            this.grabbed.field_70166_s = this.grabbed.field_70161_v = this.grabber.field_70161_v;
            this.grabbed.field_70136_U = this.grabbed.field_70161_v;
            this.grabbed.func_70012_b(this.grabbed.field_70165_t, this.grabbed.field_70163_u, this.grabbed.field_70161_v, this.grabbed.field_70177_z, this.grabbed.field_70125_A);
            EntityHelper.setVelocity(this.grabbed, grabPos.field_72450_a - this.grabbed.field_70165_t, grabPos.field_72448_b - (this.grabbed.func_174813_aQ().field_72338_b + this.grabbed.func_174813_aQ().field_72337_e) / 2.0, grabPos.field_72449_c - this.grabbed.field_70161_v);
            this.grabbed.func_70091_d(this.grabbed.field_70159_w, this.grabbed.field_70181_x, this.grabbed.field_70179_y);
            this.grabbed.func_70012_b(this.grabbed.field_70165_t, this.grabbed.field_70163_u, this.grabbed.field_70161_v, this.grabbed.field_70177_z, this.grabbed.field_70125_A);
        }
        EntityHelper.setVelocity(this.grabbed, grabPos.field_72450_a - this.grabbed.field_70165_t, grabPos.field_72448_b - (this.grabbed.func_174813_aQ().field_72338_b + this.grabbed.func_174813_aQ().field_72337_e) / 2.0, grabPos.field_72449_c - this.grabbed.field_70161_v);
        this.grabbed.field_70143_R = -((float)(this.grabbed.field_70181_x * this.grabbed.field_70181_x));
        this.grabbed.field_70122_E = false;
        this.grabbed.field_70160_al = true;
        this.grabbed.field_71088_bW = 5;
        for (GrabbedEntityHandler handler : entityHandlers) {
            if (!handler.eligible(this.grabbed)) continue;
            handler.handle(this);
        }
    }

    public void transfer(GrabHandler transfer) {
        transfer.grabDistance = this.grabDistance;
    }

    public float grabToleranceTillTeleport() {
        return 5.0f;
    }

    public boolean shouldTerminate() {
        return this.forceTerminate || this.grabber != null && this.grabbed != null && (this.grabbed.field_70128_L || !this.grabber.func_70089_S() || this.grabbed == this.grabber.func_184187_bx() || this.grabbed.field_71093_bK != this.grabber.field_71093_bK || (double)this.grabbed.func_70032_d((Entity)this.grabber) > (double)this.grabDistance + (double)this.grabToleranceTillTeleport() * 1.25);
    }

    public boolean canSendAcrossDimensions() {
        return true;
    }

    public void terminate() {
    }

    @SideOnly(value=Side.CLIENT)
    public void getIDs() {
        WorldClient client = Minecraft.func_71410_x().field_71441_e;
        if (this.grabber == null) {
            if (this.grabberId == -1) {
                this.grabber = Minecraft.func_71410_x().field_71439_g;
            } else {
                Entity ent = client.func_73045_a(this.grabberId);
                if (ent instanceof EntityLivingBase) {
                    this.grabber = (EntityLivingBase)ent;
                }
            }
        }
        if (this.grabbed == null) {
            this.grabbed = client.func_73045_a(this.grabbedId);
        }
    }

    public static void tick(Side side) {
        ArrayList<GrabHandler> ents = grabbedEntities.get(side);
        for (int i = ents.size() - 1; i >= 0; --i) {
            GrabHandler handler = ents.get(i);
            if (handler.grabber != null && handler.grabbed != null) {
                if (handler.shouldTerminate()) {
                    handler.terminate();
                    ents.remove(i);
                    continue;
                }
                handler.update();
                continue;
            }
            handler.getIDs();
        }
    }

    public static void grab(GrabHandler base, Side side) {
        ArrayList<GrabHandler> ents = grabbedEntities.get(side);
        ents.add(base);
    }

    public static GrabHandler release(EntityLivingBase grabber, Side side, Class<? extends GrabHandler> clz) {
        ArrayList<GrabHandler> ents = grabbedEntities.get(side);
        for (int i = ents.size() - 1; i >= 0; --i) {
            GrabHandler handler = ents.get(i);
            if (handler.grabber != grabber || clz != null && !clz.isInstance(handler)) continue;
            handler.terminate();
            ents.remove(i);
            return handler;
        }
        return null;
    }

    public static ArrayList<GrabHandler> getHandlers(EntityLivingBase grabber, Side side) {
        ArrayList<GrabHandler> handlers = new ArrayList<GrabHandler>();
        ArrayList<GrabHandler> ents = grabbedEntities.get(side);
        for (int i = ents.size() - 1; i >= 0; --i) {
            GrabHandler handler = ents.get(i);
            if (handler.grabber != grabber) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    public static boolean hasHandlerType(EntityLivingBase grabber, Side side, Class<? extends GrabHandler> clz) {
        return GrabHandler.getFirstHandler(grabber, side, clz) != null;
    }

    public static GrabHandler getFirstHandler(EntityLivingBase grabber, Side side, Class<? extends GrabHandler> clz) {
        for (GrabHandler handler : GrabHandler.getHandlers(grabber, side)) {
            if (clz != null && !clz.isInstance(handler)) continue;
            return handler;
        }
        return null;
    }

    public static boolean isGrabbed(Entity grabbed, Side side) {
        ArrayList<GrabHandler> ents = grabbedEntities.get(side);
        for (int i = ents.size() - 1; i >= 0; --i) {
            GrabHandler handler = ents.get(i);
            if (handler.grabbed != grabbed) continue;
            return true;
        }
        return false;
    }

    public static void registerEntityHandler(GrabbedEntityHandler handler) {
        entityHandlers.add(handler);
    }

    public static interface GrabbedEntityHandler {
        public boolean eligible(Entity var1);

        public void handle(GrabHandler var1);
    }
}

