/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.core.util.ObfHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfoLerping;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHelper {
    public static final UUID uuidExample = UUID.fromString("DEADBEEF-DEAD-BEEF-DEAD-DEADBEEFD00D");
    public static HashMap<String, GameProfile> gameProfileCache = new HashMap();
    public static PlayerProfileCache profileCache;
    public static MinecraftSessionService sessionService;
    private static GameProfile dummyProfile;
    public static final Map<UUID, BossInfoLerping> BOSS_INFO_STORE;

    @SideOnly(value=Side.CLIENT)
    public static void injectMinecraftPlayerGameProfile() {
        gameProfileCache.put(Minecraft.func_71410_x().func_110432_I().func_111285_a(), Minecraft.func_71410_x().func_110432_I().func_148256_e());
    }

    public static GameProfile getDummyGameProfile() {
        return dummyProfile;
    }

    public static GameProfile getGameProfile(String playerName) {
        GameProfile gameprofile;
        if (gameProfileCache.containsKey(playerName)) {
            return gameProfileCache.get(playerName);
        }
        if (profileCache == null || sessionService == null) {
            iChunUtil.proxy.setGameProfileLookupService();
        }
        if ((gameprofile = profileCache.func_152655_a(playerName)) == null) {
            return new GameProfile(null, playerName);
        }
        Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
        if (property == null) {
            gameprofile = sessionService.fillProfileProperties(gameprofile, true);
            gameProfileCache.put(playerName, gameprofile);
        }
        return gameprofile;
    }

    @SideOnly(value=Side.CLIENT)
    public static void storeBossStatus() {
        BOSS_INFO_STORE.clear();
        Iterator ite = Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry e = ite.next();
            BOSS_INFO_STORE.put((UUID)e.getKey(), (BossInfoLerping)e.getValue());
            ite.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void restoreBossStatus() {
        Map bossMap = Minecraft.func_71410_x().field_71456_v.func_184046_j().field_184060_g;
        Iterator<Map.Entry<UUID, BossInfoLerping>> ite = BOSS_INFO_STORE.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<UUID, BossInfoLerping> e = ite.next();
            bossMap.put(e.getKey(), e.getValue());
            ite.remove();
        }
        BOSS_INFO_STORE.clear();
    }

    public static boolean consumeInventoryItem(InventoryPlayer inventory, Item item) {
        if (inventory.field_184439_c[0] != null && inventory.field_184439_c[0].func_77973_b() == item) {
            if (--inventory.field_184439_c[0].field_77994_a <= 0) {
                inventory.field_184439_c[0] = null;
            }
            inventory.func_70296_d();
            return true;
        }
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            if (inventory.field_70462_a[i] == null || inventory.field_70462_a[i].func_77973_b() != item) continue;
            if (--inventory.field_70462_a[i].field_77994_a <= 0) {
                inventory.field_70462_a[i] = null;
            }
            inventory.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inventory, Item item, int damage, int amount) {
        ItemStack[] stacks;
        boolean offhand = false;
        int found = 0;
        if (inventory.field_184439_c[0] != null && inventory.field_184439_c[0].func_77973_b() == item && (inventory.field_184439_c[0].func_77952_i() == damage || inventory.field_184439_c[0].func_77952_i() == Short.MAX_VALUE)) {
            found += inventory.field_184439_c[0].field_77994_a;
            offhand = true;
        }
        for (ItemStack is2 : stacks = (ItemStack[])Arrays.stream(inventory.field_70462_a).filter(is -> is != null && is.func_77973_b() == item && (is.func_77952_i() == damage || is.func_77952_i() == Short.MAX_VALUE)).toArray(ItemStack[]::new)) {
            found += is2.field_77994_a;
        }
        if (found < amount) {
            return false;
        }
        if (offhand) {
            while (amount > 0 && inventory.field_184439_c[0].field_77994_a > 0) {
                --amount;
                if (--inventory.field_184439_c[0].field_77994_a > 0) continue;
                inventory.field_184439_c[0] = null;
            }
            for (int i = 0; i < inventory.field_70462_a.length; ++i) {
                ItemStack is3 = inventory.field_70462_a[i];
                if (is3 != null && is3.func_77973_b() == item && (is3.func_77952_i() == damage || is3.func_77952_i() == Short.MAX_VALUE)) {
                    while (amount > 0 && is3.field_77994_a > 0) {
                        --amount;
                        if (--is3.field_77994_a > 0) continue;
                        inventory.field_70462_a[i] = null;
                    }
                }
                if (amount <= 0) break;
            }
        }
        return true;
    }

    public static void playSoundAtEntity(Entity ent, SoundEvent soundEvent, SoundCategory soundCategory, float volume, float pitch) {
        ent.field_70170_p.func_184148_a(ent.field_70170_p.field_72995_K ? iChunUtil.proxy.getMcPlayer() : null, ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v, soundEvent, soundCategory, volume, pitch);
    }

    public static <T extends EntityLivingBase> SoundEvent getHurtSound(T ent, Class clz) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscated() ? "func_184601_bQ" : "getHurtSound", new Class[0]);
            m.setAccessible(true);
            return (SoundEvent)m.invoke(ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelper.getHurtSound(ent, clz.getSuperclass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SoundEvents.field_187543_bD;
    }

    public static <T extends EntityLivingBase> SoundEvent getDeathSound(T ent, Class clz) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscated() ? "func_188593_c" : "getDeathSound", new Class[0]);
            m.setAccessible(true);
            return (SoundEvent)m.invoke(ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelper.getDeathSound(ent, clz.getSuperclass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SoundEvents.field_187661_by;
    }

    public static float updateRotation(float oriRot, float intendedRot, float maxChange) {
        float var4 = MathHelper.func_76142_g((float)(intendedRot - oriRot));
        if (var4 > maxChange) {
            var4 = maxChange;
        }
        if (var4 < -maxChange) {
            var4 = -maxChange;
        }
        return oriRot + var4;
    }

    public static void faceEntity(Entity facer, Entity faced, float maxYaw, float maxPitch) {
        EntityHelper.faceLocation(facer, faced.field_70165_t, faced instanceof EntityLivingBase ? faced.field_70163_u + (double)faced.func_70047_e() : (faced.func_174813_aQ().field_72338_b + faced.func_174813_aQ().field_72337_e) / 2.0, faced.field_70161_v, maxYaw, maxPitch);
    }

    public static void faceLocation(Entity facer, double posX, double posY, double posZ, float maxYaw, float maxPitch) {
        double d0 = posX - facer.field_70165_t;
        double d1 = posZ - facer.field_70161_v;
        double d2 = posY - (facer.field_70163_u + (double)facer.func_70047_e());
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        facer.field_70125_A = EntityHelper.updateRotation(facer.field_70125_A, f3, maxPitch);
        facer.field_70177_z = EntityHelper.updateRotation(facer.field_70177_z, f2, maxYaw);
    }

    public static Vec3d getEntityPositionEyes(Entity ent, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        }
        double d0 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)partialTicks;
        double d1 = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)partialTicks + (double)ent.func_70047_e();
        double d2 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }

    public static float interpolateRotation(float prevRotation, float nextRotation, float partialTick) {
        float f3;
        for (f3 = nextRotation - prevRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return prevRotation + partialTick * f3;
    }

    public static float interpolateValues(float prevVal, float nextVal, float partialTick) {
        return prevVal + partialTick * (nextVal - prevVal);
    }

    public static void setVelocity(Entity entity, double d, double d1, double d2) {
        entity.field_70159_w = d;
        entity.field_70181_x = d1;
        entity.field_70179_y = d2;
    }

    public static RayTraceResult getEntityLook(Entity ent, double d) {
        return EntityHelper.getEntityLook(ent, d, false);
    }

    public static RayTraceResult getEntityLook(Entity ent, double d, boolean ignoreEntities) {
        return EntityHelper.getEntityLook(ent, d, ignoreEntities, false, true, 1.0f);
    }

    public static RayTraceResult getEntityLook(Entity ent, double d, boolean ignoreEntities, boolean ignoreTransparentBlocks, boolean ignoreLiquid, float renderTick) {
        Vec3d vec3 = EntityHelper.getEntityPositionEyes(ent, renderTick);
        Vec3d vec31 = ent.func_70676_i(renderTick);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        RayTraceResult rayTrace = EntityHelper.rayTraceBlocks(ent.field_70170_p, d, vec3, vec32, !ignoreLiquid, ignoreTransparentBlocks, false, true);
        if (!ignoreEntities) {
            double dist = d;
            if (rayTrace != null) {
                dist = rayTrace.field_72307_f.func_72438_d(vec3);
            }
            Entity entityTrace = null;
            Vec3d vec33 = null;
            float f = 1.0f;
            List list = ent.field_70170_p.func_175674_a(ent, ent.func_174813_aQ().func_72321_a(vec31.field_72450_a * dist, vec31.field_72448_b * dist, vec31.field_72449_c * dist).func_72314_b((double)f, (double)f, (double)f), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(Entity p_apply_1_) {
                    return p_apply_1_.func_70067_L();
                }
            }));
            double d2 = dist;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                float f1 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
                if (axisalignedbb.func_72318_a(vec3)) {
                    if (!(d2 >= 0.0)) continue;
                    entityTrace = entity1;
                    vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == ent.func_184187_bx() && !ent.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    entityTrace = entity1;
                    vec33 = movingobjectposition.field_72307_f;
                    continue;
                }
                entityTrace = entity1;
                vec33 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (entityTrace != null && (d2 < dist || rayTrace == null)) {
                rayTrace = new RayTraceResult(entityTrace, vec33);
            }
        }
        return rayTrace;
    }

    public static RayTraceResult rayTraceBlocks(World world, double dist, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreTransparentBlocks, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult mop;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (!(ignoreBlockWithoutBoundingBox && iblockstate.func_185890_d(world, blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) || ignoreTransparentBlocks && EntityHelper.isTransparent(block, iblockstate, world, blockpos) || (mop = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) == null)) {
                    return mop;
                }
                RayTraceResult movingobjectposition2 = null;
                int k1 = (int)Math.ceil(dist + 1.0);
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? movingobjectposition2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d(world, blockpos) == Block.field_185506_k || ignoreTransparentBlocks && EntityHelper.isTransparent(block1, iblockstate1, world, blockpos)) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult movingobjectposition1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (movingobjectposition1 == null) continue;
                        return movingobjectposition1;
                    }
                    movingobjectposition2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? movingobjectposition2 : null;
            }
            return null;
        }
        return null;
    }

    public static void addPosition(Entity living, double offset, boolean subtract, int axis) {
        if (subtract) {
            offset = -offset;
        }
        if (axis == 0) {
            living.field_70142_S += offset;
            living.field_70169_q += offset;
            living.field_70165_t += offset;
        } else if (axis == 1) {
            living.field_70137_T += offset;
            living.field_70167_r += offset;
            living.field_70163_u += offset;
        } else if (axis == 2) {
            living.field_70136_U += offset;
            living.field_70166_s += offset;
            living.field_70161_v += offset;
        }
    }

    public static void relocateEntity(EnumFacing.Axis axis, Entity ent, double degree, double originX, double originY, double originZ, double destX, double destY, double destZ, float renderTick) {
        double rads = Math.toRadians(degree);
        if (axis == EnumFacing.Axis.Y) {
            iChunUtil.proxy.adjustRotation(ent, (float)(-degree), 0.0f);
        }
    }

    public static AxisAlignedBB rotateAABB(EnumFacing.Axis axis, AxisAlignedBB aabb, double degree, double originX, double originY, double originZ) {
        double rads = Math.toRadians(degree);
        if (axis == EnumFacing.Axis.X) {
            double oriZ = aabb.field_72339_c - originZ;
            double oriY = aabb.field_72338_b - originY;
            double z1 = oriZ * Math.cos(rads) + oriY * Math.sin(rads);
            double y1 = -oriZ * Math.sin(rads) + oriY * Math.cos(rads);
            oriZ = aabb.field_72334_f - originZ;
            oriY = aabb.field_72337_e - originY;
            double z2 = oriZ * Math.cos(rads) + oriY * Math.sin(rads);
            double y2 = -oriZ * Math.sin(rads) + oriY * Math.cos(rads);
            return new AxisAlignedBB(aabb.field_72340_a, Math.min(y1, y2) + originY, Math.min(z1, z2) + originZ, aabb.field_72336_d, Math.max(y1, y2) + originY, Math.max(z1, z2) + originZ);
        }
        if (axis == EnumFacing.Axis.Y) {
            double oriX = aabb.field_72340_a - originX;
            double oriZ = aabb.field_72339_c - originZ;
            double x1 = oriX * Math.cos(rads) + oriZ * Math.sin(rads);
            double z1 = -oriX * Math.sin(rads) + oriZ * Math.cos(rads);
            oriX = aabb.field_72336_d - originX;
            oriZ = aabb.field_72334_f - originZ;
            double x2 = oriX * Math.cos(rads) + oriZ * Math.sin(rads);
            double z2 = -oriX * Math.sin(rads) + oriZ * Math.cos(rads);
            return new AxisAlignedBB(Math.min(x1, x2) + originX, aabb.field_72338_b, Math.min(z1, z2) + originZ, Math.max(x1, x2) + originX, aabb.field_72337_e, Math.max(z1, z2) + originZ);
        }
        if (axis == EnumFacing.Axis.Z) {
            double oriX = aabb.field_72340_a - originX;
            double oriY = aabb.field_72338_b - originY;
            double x1 = oriX * Math.cos(rads) + oriY * Math.sin(rads);
            double y1 = -oriX * Math.sin(rads) + oriY * Math.cos(rads);
            oriX = aabb.field_72336_d - originX;
            oriY = aabb.field_72337_e - originY;
            double x2 = oriX * Math.cos(rads) + oriY * Math.sin(rads);
            double y2 = -oriX * Math.sin(rads) + oriY * Math.cos(rads);
            return new AxisAlignedBB(Math.min(x1, x2) + originX, Math.min(y1, y2) + originY, aabb.field_72339_c, Math.max(x1, x2) + originX, Math.max(y1, y2) + originY, aabb.field_72334_f);
        }
        return aabb;
    }

    public static boolean destroyBlocksInAABB(Entity ent, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int k = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int l = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = ent.field_70170_p.func_180495_p(blockpos);
                    Block block = ent.field_70170_p.func_180495_p(blockpos).func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)ent.field_70170_p, blockpos) || iblockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (!ent.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag = true;
                        continue;
                    }
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)ent.field_70170_p, blockpos, ent)) {
                        if (block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db) {
                            flag1 = ent.field_70170_p.func_175698_g(blockpos) || flag1;
                            continue;
                        }
                        flag = true;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d1 = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d2 = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            ent.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public static NBTTagCompound getPlayerPersistentData(EntityPlayer player) {
        NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        return persistentTag;
    }

    public static NBTTagCompound getPlayerPersistentData(EntityPlayer player, String name) {
        NBTTagCompound persistentTag = EntityHelper.getPlayerPersistentData(player).func_74775_l(name);
        EntityHelper.getPlayerPersistentData(player).func_74782_a(name, (NBTBase)persistentTag);
        return persistentTag;
    }

    public static boolean isTransparent(Block block, IBlockState state, World world, BlockPos pos) {
        return block.getLightOpacity(state, (IBlockAccess)world, pos) != 255;
    }

    static {
        dummyProfile = new GameProfile(uuidExample, "ForgeDev");
        BOSS_INFO_STORE = Maps.newLinkedHashMap();
    }
}

