/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.network;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class PacketHandlerWrapper<REQ extends AbstractPacket>
extends SimpleChannelInboundHandler<REQ> {
    private final Side side;

    public PacketHandlerWrapper(Side side, Class<REQ> requestType) {
        super(requestType);
        this.side = side;
    }

    protected void channelRead0(ChannelHandlerContext ctx, REQ msg) throws Exception {
        EntityPlayer player;
        if (this.side.isServer()) {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            player = ((NetHandlerPlayServer)netHandler).field_147369_b;
        } else {
            player = this.getClientPlayer();
        }
        if (!((AbstractPacket)msg).requiresMainThread()) {
            this.executeMessage((AbstractPacket)msg, player, this.side, ctx);
        } else {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
            if (thread.func_152345_ab()) {
                this.executeMessage((AbstractPacket)msg, player, this.side, ctx);
            } else {
                thread.func_152344_a(() -> this.executeMessage((AbstractPacket)msg, player, this.side, ctx));
            }
        }
    }

    public void executeMessage(AbstractPacket msg, EntityPlayer player, Side side, ChannelHandlerContext ctx) {
        AbstractPacket result = msg.execute(side, player);
        if (result != null) {
            if (side.isServer()) {
                ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
                ctx.writeAndFlush((Object)result).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            } else {
                ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
                ctx.writeAndFlush((Object)result).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"iChunUtil Packet exception", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

