/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.core.network;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.network.PacketHandlerWrapper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class PacketChannel {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private AbstractPacketCodec packetCodec;
    private static Class<?> defaultChannelPipeline;
    private static Method generateName;

    private String generateName(ChannelPipeline pipeline, ChannelHandler handler) {
        try {
            return (String)generateName.invoke(defaultChannelPipeline.cast(pipeline), handler);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"It appears we somehow have a not-standard pipeline. Huh", (Object[])new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public PacketChannel(String modId, Class<? extends AbstractPacket> ... packetTypes) {
        try {
            defaultChannelPipeline = Class.forName("io.netty.channel.DefaultChannelPipeline");
            generateName = defaultChannelPipeline.getDeclaredMethod("generateName", ChannelHandler.class);
            generateName.setAccessible(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"What? Netty isn't installed, what magic is this?", (Object[])new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        if (packetTypes.length == 0) {
            throw new ReportedException(new CrashReport("Mod " + modId + " is not registering any packets with its channel handlers.", new Throwable()));
        }
        this.packetCodec = new AbstractPacketCodec();
        this.channels = NetworkRegistry.INSTANCE.newChannel(modId, new ChannelHandler[]{this.packetCodec});
        ArrayList<Class<? extends AbstractPacket>> list = new ArrayList<Class<? extends AbstractPacket>>();
        for (Class<? extends AbstractPacket> packetType : packetTypes) {
            if (!list.contains(packetType)) {
                list.add(packetType);
                continue;
            }
            iChunUtil.LOGGER.warn("Channel " + modId + " is reregistering packet types!");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.registerPacket(modId, i, (Class)list.get(i));
        }
    }

    public void registerPacket(String modId, int i, Class<? extends AbstractPacket> packetClass) {
        this.packetCodec.addDiscriminator(i, packetClass);
        try {
            Side side = packetClass.newInstance().receivingSide();
            if (side == null) {
                FMLEmbeddedChannel channelServer = this.channels.get(Side.SERVER);
                String typeServer = channelServer.findChannelHandlerNameForType(AbstractPacketCodec.class);
                PacketHandlerWrapper<? extends AbstractPacket> handlerServer = new PacketHandlerWrapper<AbstractPacket>(Side.SERVER, packetClass);
                channelServer.pipeline().addAfter(typeServer, this.generateName(channelServer.pipeline(), (ChannelHandler)handlerServer), handlerServer);
                FMLEmbeddedChannel channelClient = this.channels.get(Side.CLIENT);
                String typeClient = channelClient.findChannelHandlerNameForType(AbstractPacketCodec.class);
                PacketHandlerWrapper<? extends AbstractPacket> handlerClient = new PacketHandlerWrapper<AbstractPacket>(Side.CLIENT, packetClass);
                channelClient.pipeline().addAfter(typeClient, this.generateName(channelClient.pipeline(), (ChannelHandler)handlerClient), handlerClient);
            } else {
                FMLEmbeddedChannel channel = this.channels.get(side);
                String type = channel.findChannelHandlerNameForType(AbstractPacketCodec.class);
                PacketHandlerWrapper<? extends AbstractPacket> handler = new PacketHandlerWrapper<AbstractPacket>(side, packetClass);
                channel.pipeline().addAfter(type, this.generateName(channel.pipeline(), (ChannelHandler)handler), handler);
            }
        }
        catch (Exception e) {
            iChunUtil.LOGGER.warn("Could not create packet for class " + packetClass.getName() + " for channel " + modId + ". Is there a default constructor in that class?");
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Packet<?> getPacketFrom(AbstractPacket message) {
        return this.channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public void sendToAllExcept(AbstractPacket packet, EntityPlayer player) {
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().size(); ++i) {
            EntityPlayerMP player1 = (EntityPlayerMP)FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().get(i);
            if (player.func_70005_c_().equalsIgnoreCase(player1.func_70005_c_())) continue;
            this.sendTo(packet, (EntityPlayer)player1);
        }
    }

    public void sendToAll(AbstractPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(AbstractPacket message, EntityPlayer player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(AbstractPacket message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(AbstractPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(AbstractPacket message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public class AbstractPacketCodec
    extends FMLIndexedMessageToMessageCodec<AbstractPacket> {
        public void encodeInto(ChannelHandlerContext ctx, AbstractPacket msg, ByteBuf target) throws Exception {
            msg.writeTo(target);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, AbstractPacket msg) {
            msg.readFrom(source);
        }
    }
}

