/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import gnu.trove.map.hash.TIntFloatHashMap;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public final class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static TIntFloatHashMap prevTime = new TIntFloatHashMap();

    public static void useShader(int shader, IShaderCallback callback) {
        if (!ShaderHelper.supportsShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            boolean newFrame;
            float frameTime = (float)iChunUtil.eventHandlerClient.ticks + iChunUtil.eventHandlerClient.renderTick;
            boolean bl = newFrame = frameTime != prevTime.get(shader);
            if (newFrame) {
                int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
                ARBShaderObjects.glUniform1fARB((int)time, (float)frameTime);
                prevTime.put(shader, frameTime);
            }
            if (callback != null) {
                callback.call(shader, newFrame);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean supportsShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static int createProgram(String vert, String frag) {
        if (!ShaderHelper.supportsShaders()) {
            return -1;
        }
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            iChunUtil.LOGGER.error(ShaderHelper.getLogInfo(program));
            ARBShaderObjects.glDeleteObjectARB((int)program);
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            iChunUtil.LOGGER.error(ShaderHelper.getLogInfo(program));
            ARBShaderObjects.glDeleteObjectARB((int)program);
            return 0;
        }
        prevTime.put(program, -1.0f);
        return program;
    }

    private static int createShader(String shaderString, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)shaderString);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static interface IShaderCallback {
        public void call(int var1, boolean var2);
    }
}

