/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.model.item;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import me.ichun.mods.ichunutil.client.model.item.IModelBase;
import me.ichun.mods.ichunutil.client.render.item.ItemRenderingHelper;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class ModelBaseWrapper
implements IBakedModel,
IPerspectiveAwareModel {
    private static final List<BakedQuad> DUMMY_LIST = Collections.emptyList();
    @Nonnull
    private final IModelBase modelBase;
    private final Pair<IBakedModel, Matrix4f> selfPair;
    @Nonnull
    private VertexFormat defaultVertexFormat = DefaultVertexFormats.field_176599_b;
    private boolean isItemDualHanded = false;
    private boolean disableRender = false;
    private ItemCameraTransforms.TransformType currentPerspective;
    private ItemStack lastStack;
    private EntityLivingBase lastEntity;

    public ModelBaseWrapper(@Nonnull IModelBase renderer) {
        this.modelBase = renderer;
        this.selfPair = Pair.of((Object)this, null);
    }

    public ModelBaseWrapper(@Nonnull IModelBase renderer, @Nonnull VertexFormat defVertexFormat) {
        this(renderer);
        this.defaultVertexFormat = defVertexFormat;
    }

    public ModelBaseWrapper setItemDualHanded() {
        this.isItemDualHanded = true;
        return this;
    }

    public void setDisableRender(boolean disable) {
        this.disableRender = disable;
    }

    public void handleBlockState(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        this.modelBase.handleBlockState(state, side, rand);
    }

    public void bindTexture(@Nonnull ResourceLocation rs) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
    }

    protected void rebindTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return DUMMY_LIST;
        }
        this.handleBlockState(state, side, rand);
        if (!this.disableRender) {
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_78381_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.bindTexture(this.modelBase.getTexture());
            this.modelBase.renderModel(iChunUtil.eventHandlerClient.renderTick);
            this.modelBase.postRender();
            this.rebindTexture();
            GlStateManager.func_179121_F();
            this.currentPerspective = null;
            this.lastStack = null;
            this.lastEntity = null;
            VertexBuffer vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, this.defaultVertexFormat);
        }
        return DUMMY_LIST;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.modelBase.getCameraTransforms();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.currentPerspective = cameraTransformType;
        Pair<? extends IBakedModel, Matrix4f> pair = this.modelBase.handlePerspective(cameraTransformType, this.selfPair);
        if (this.modelBase.useVanillaCameraTransform()) {
            boolean isLeft = ModelBaseWrapper.isLeftHand(cameraTransformType);
            if (this.isItemDualHanded && ModelBaseWrapper.isFirstPerson(this.currentPerspective) && this.lastEntity instanceof EntityPlayer && ItemRenderingHelper.dualHandedAnimationRight > 0) {
                float prog = (float)Math.sin((double)MathHelper.func_76131_a((float)((isLeft ? EntityHelper.interpolateValues(ItemRenderingHelper.prevDualHandedAnimationLeft, ItemRenderingHelper.dualHandedAnimationLeft, iChunUtil.eventHandlerClient.renderTick) : EntityHelper.interpolateValues(ItemRenderingHelper.prevDualHandedAnimationRight, ItemRenderingHelper.dualHandedAnimationRight, iChunUtil.eventHandlerClient.renderTick)) / (float)ItemRenderingHelper.dualHandedAnimationTime), (float)0.0f, (float)1.0f) * Math.PI / 4.0);
                GlStateManager.func_179114_b((float)(30.0f * prog), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-0.1f * prog), (float)(0.3f * prog));
                GlStateManager.func_179114_b((float)((isLeft ? -35.0f : 35.0f) * prog), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            ItemCameraTransforms.func_188034_a((ItemTransformVec3f)this.func_177552_f().func_181688_b(cameraTransformType), (boolean)isLeft);
        }
        return pair;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListHandler.INSTANCE.setModelBaseWrapper(this);
    }

    public static boolean isFirstPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
    }

    public static boolean isThirdPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isEntityRender(ItemCameraTransforms.TransformType type) {
        return ModelBaseWrapper.isFirstPerson(type) || ModelBaseWrapper.isThirdPerson(type);
    }

    public static boolean isLeftHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }

    public static boolean isRightHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isItemRender(ItemCameraTransforms.TransformType type) {
        return type == null || type == ItemCameraTransforms.TransformType.GROUND || type == ItemCameraTransforms.TransformType.NONE;
    }

    private static final class ItemOverrideListHandler
    extends ItemOverrideList {
        private static final ItemOverrideListHandler INSTANCE = new ItemOverrideListHandler();
        private ModelBaseWrapper modelBaseWrapper;

        private ItemOverrideListHandler() {
            super((List)ImmutableList.of());
        }

        private ItemOverrideListHandler setModelBaseWrapper(ModelBaseWrapper model) {
            this.modelBaseWrapper = model;
            return this;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            this.modelBaseWrapper.lastStack = stack;
            this.modelBaseWrapper.lastEntity = entity;
            this.modelBaseWrapper.modelBase.handleItemState(stack, world, entity);
            return originalModel;
        }
    }
}

