/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import java.util.ArrayList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class FacingUtils {
    public static final BlockPos[] AROUND_X = new BlockPos[]{new BlockPos(0, 1, -1), new BlockPos(0, 1, 0), new BlockPos(0, 1, 1), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, -1, -1), new BlockPos(0, -1, 0), new BlockPos(0, -1, 1)};
    public static final BlockPos[] AROUND_Y = new BlockPos[]{new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1)};
    public static final BlockPos[] AROUND_Z = new BlockPos[]{new BlockPos(1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-1, 1, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-1, -1, 0)};
    public static final BlockPos[] AROUND_ALL;
    public static final EnumFacing[] FACES_AROUND_X;
    public static final EnumFacing[] FACES_AROUND_Y;
    public static final EnumFacing[] FACES_AROUND_Z;

    public static BlockPos[] getAroundAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return AROUND_X;
        }
        if (axis == EnumFacing.Axis.Y) {
            return AROUND_Y;
        }
        return AROUND_Z;
    }

    public static EnumFacing[] getFacingsAroundAxis(EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return FACES_AROUND_X;
        }
        if (axis == EnumFacing.Axis.Y) {
            return FACES_AROUND_Y;
        }
        return FACES_AROUND_Z;
    }

    public static EnumFacing rotateAround(EnumFacing facing, EnumFacing.Axis axis, boolean reverse) {
        switch (axis) {
            case X: {
                if (facing != EnumFacing.WEST && facing != EnumFacing.EAST) {
                    return FacingUtils.rotateX(facing, reverse);
                }
                return facing;
            }
            case Y: {
                if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
                    return FacingUtils.rotateY(facing, reverse);
                }
                return facing;
            }
            case Z: {
                if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) {
                    return FacingUtils.rotateZ(facing, reverse);
                }
                return facing;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    private static EnumFacing rotateY(EnumFacing facing, boolean reverse) {
        switch (facing) {
            case NORTH: {
                return reverse ? EnumFacing.WEST : EnumFacing.EAST;
            }
            case EAST: {
                return reverse ? EnumFacing.NORTH : EnumFacing.SOUTH;
            }
            case SOUTH: {
                return reverse ? EnumFacing.EAST : EnumFacing.WEST;
            }
            case WEST: {
                return reverse ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + facing);
    }

    private static EnumFacing rotateX(EnumFacing facing, boolean reverse) {
        switch (facing) {
            case NORTH: {
                return reverse ? EnumFacing.UP : EnumFacing.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + facing);
            }
            case SOUTH: {
                return reverse ? EnumFacing.DOWN : EnumFacing.UP;
            }
            case UP: {
                return reverse ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            case DOWN: 
        }
        return reverse ? EnumFacing.NORTH : EnumFacing.SOUTH;
    }

    private static EnumFacing rotateZ(EnumFacing facing, boolean reverse) {
        switch (facing) {
            case EAST: {
                return reverse ? EnumFacing.UP : EnumFacing.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + facing);
            }
            case WEST: {
                return reverse ? EnumFacing.DOWN : EnumFacing.UP;
            }
            case UP: {
                return reverse ? EnumFacing.WEST : EnumFacing.EAST;
            }
            case DOWN: 
        }
        return reverse ? EnumFacing.EAST : EnumFacing.WEST;
    }

    static {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos pos : AROUND_X) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        for (BlockPos pos : AROUND_Y) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        for (BlockPos pos : AROUND_Z) {
            if (list.contains(pos)) continue;
            list.add(pos);
        }
        AROUND_ALL = list.toArray(new BlockPos[0]);
        ArrayList<EnumFacing> x = new ArrayList<EnumFacing>();
        ArrayList<EnumFacing> y = new ArrayList<EnumFacing>();
        ArrayList<EnumFacing> z = new ArrayList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() != EnumFacing.Axis.X) {
                x.add(facing);
            }
            if (facing.func_176740_k() != EnumFacing.Axis.Y) {
                y.add(facing);
            }
            if (facing.func_176740_k() == EnumFacing.Axis.Z) continue;
            z.add(facing);
        }
        FACES_AROUND_X = x.toArray(new EnumFacing[1]);
        FACES_AROUND_Y = y.toArray(new EnumFacing[1]);
        FACES_AROUND_Z = z.toArray(new EnumFacing[1]);
    }
}

