/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.craftingitem;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import mod.flatcoloredblocks.craftingitem.ContainerColoredBlockCrafter;
import mod.flatcoloredblocks.craftingitem.InventorySummary;
import mod.flatcoloredblocks.craftingitem.ItemCraftingSource;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryColoredBlockCrafter
implements IInventory {
    private final EntityPlayer thePlayer;
    private final ContainerColoredBlockCrafter craftingContainer;
    private final ArrayList<ItemStack> options = new ArrayList();
    public int offset = 0;

    public InventoryColoredBlockCrafter(EntityPlayer thePlayer, ContainerColoredBlockCrafter coloredCrafterContainer) {
        this.thePlayer = thePlayer;
        this.craftingContainer = coloredCrafterContainer;
    }

    public static HashMap<Object, List<ItemStack>> getDyeList() {
        HashMap<Object, List<ItemStack>> dyeList = new HashMap<Object, List<ItemStack>>();
        dyeList.put(EnumDyeColor.BLACK, OreDictionary.getOres((String)"dyeBlack"));
        dyeList.put(EnumDyeColor.RED, OreDictionary.getOres((String)"dyeRed"));
        dyeList.put(EnumDyeColor.GREEN, OreDictionary.getOres((String)"dyeGreen"));
        dyeList.put(EnumDyeColor.BROWN, OreDictionary.getOres((String)"dyeBrown"));
        dyeList.put(EnumDyeColor.BLUE, OreDictionary.getOres((String)"dyeBlue"));
        dyeList.put(EnumDyeColor.PURPLE, OreDictionary.getOres((String)"dyePurple"));
        dyeList.put(EnumDyeColor.CYAN, OreDictionary.getOres((String)"dyeCyan"));
        dyeList.put(EnumDyeColor.SILVER, OreDictionary.getOres((String)"dyeLightGray"));
        dyeList.put(EnumDyeColor.GRAY, OreDictionary.getOres((String)"dyeGray"));
        dyeList.put(EnumDyeColor.PINK, OreDictionary.getOres((String)"dyePink"));
        dyeList.put(EnumDyeColor.LIME, OreDictionary.getOres((String)"dyeLime"));
        dyeList.put(EnumDyeColor.YELLOW, OreDictionary.getOres((String)"dyeYellow"));
        dyeList.put(EnumDyeColor.LIGHT_BLUE, OreDictionary.getOres((String)"dyeLightBlue"));
        dyeList.put(EnumDyeColor.MAGENTA, OreDictionary.getOres((String)"dyeMagenta"));
        dyeList.put(EnumDyeColor.ORANGE, OreDictionary.getOres((String)"dyeOrange"));
        dyeList.put(EnumDyeColor.WHITE, OreDictionary.getOres((String)"dyeWhite"));
        dyeList.put((Object)EnumFlatBlockType.NORMAL, InventoryColoredBlockCrafter.getItems(FlatColoredBlocks.instance.config.solidCraftingBlock));
        dyeList.put((Object)EnumFlatBlockType.GLOWING, InventoryColoredBlockCrafter.getItems(FlatColoredBlocks.instance.config.glowingCraftingBlock));
        dyeList.put((Object)EnumFlatBlockType.TRANSPARENT, InventoryColoredBlockCrafter.getItems(FlatColoredBlocks.instance.config.transparentCraftingBlock));
        return dyeList;
    }

    private InventorySummary scanPlayerInventory() {
        EnumSet<EnumDyeColor> dyes = EnumSet.noneOf(EnumDyeColor.class);
        InventoryPlayer ip = this.thePlayer.field_71071_by;
        HashMap<Object, List<ItemStack>> dyeList = InventoryColoredBlockCrafter.getDyeList();
        HashMap<Object, HashSet<ItemCraftingSource>> stacks = new HashMap<Object, HashSet<ItemCraftingSource>>();
        boolean hasCobblestone = false;
        boolean hasGlowstone = false;
        boolean hasGlass = false;
        for (Map.Entry<Object, List<ItemStack>> items : dyeList.entrySet()) {
            stacks.put(items.getKey(), new HashSet());
        }
        stacks.put(null, new HashSet());
        for (int x = 0; x < ip.func_70302_i_(); ++x) {
            ItemStack is = ip.func_70301_a(x);
            if (is == null) continue;
            for (Map.Entry<Object, List<ItemStack>> items : dyeList.entrySet()) {
                for (ItemStack ore : items.getValue()) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)is, (boolean)false)) continue;
                    if (items.getKey() instanceof EnumDyeColor) {
                        dyes.add((EnumDyeColor)items.getKey());
                    } else {
                        if (items.getKey() == EnumFlatBlockType.NORMAL) {
                            hasCobblestone = true;
                        }
                        if (items.getKey() == EnumFlatBlockType.TRANSPARENT) {
                            hasGlass = true;
                        }
                        if (items.getKey() == EnumFlatBlockType.GLOWING) {
                            hasGlowstone = true;
                        }
                    }
                    stacks.get(items.getKey()).add(new ItemCraftingSource(ip, x));
                }
            }
        }
        return new InventorySummary(hasCobblestone, hasGlowstone, hasGlass, stacks, dyes);
    }

    private static List<ItemStack> getItems(String name) {
        ArrayList<ItemStack> items = OreDictionary.getOres((String)name, (boolean)false);
        if (items.isEmpty()) {
            items = new ArrayList<ItemStack>();
            Item it = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (it != null) {
                items.add(new ItemStack(it, 1, Short.MAX_VALUE));
            }
        }
        return items;
    }

    public void updateContents() {
        this.options.clear();
        BlockFlatColored.getAllShades(this.options);
        InventorySummary da = this.scanPlayerInventory();
        EnumSet<EnumDyeColor> dyes = da.dyes;
        Iterator<ItemStack> i = this.options.iterator();
        while (i.hasNext()) {
            ItemStack is = i.next();
            Block blk = Block.func_149634_a((Item)is.func_77973_b());
            IBlockState state = blk.func_176203_a(is.func_77952_i());
            Set<EnumFlatColorAttributes> charistics = ((BlockFlatColored)blk).getFlatColorAttributes(state);
            boolean isGood = true;
            for (EnumFlatColorAttributes cc : charistics) {
                if (dyes.contains(cc.primaryDye) && dyes.contains(cc.secondaryDye)) continue;
                isGood = false;
            }
            EnumDyeColor alternateDye = EnumFlatColorAttributes.getAlternateDye(charistics);
            if (alternateDye != null && dyes.contains(alternateDye)) {
                isGood = true;
            }
            if (isGood && da.has(((BlockFlatColored)blk).getCraftable())) continue;
            i.remove();
        }
        this.craftingContainer.setScroll(this.craftingContainer.scrollPercent);
    }

    public String func_70005_c_() {
        return this.thePlayer.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.options.size();
    }

    public ItemStack func_70301_a(int index) {
        if ((index += this.offset) < this.options.size()) {
            return this.options.get(index).func_77946_l();
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        if ((index += this.offset) < this.options.size()) {
            ItemStack out = this.options.get(index);
            if (out.field_77994_a <= 0) {
                out = null;
            }
            return out;
        }
        return null;
    }

    public ItemStack craftItem(ItemStack out, int count, boolean simulate) {
        if (out == null) {
            return null;
        }
        out = out.func_77946_l();
        out.field_77994_a = 0;
        InventorySummary da = this.scanPlayerInventory();
        Block blk = Block.func_149634_a((Item)out.func_77973_b());
        IBlockState state = blk.func_176203_a(out.func_77952_i());
        Set<EnumFlatColorAttributes> charistics = ((BlockFlatColored)blk).getFlatColorAttributes(state);
        EnumFlatBlockType Craftable = ((BlockFlatColored)blk).getCraftable();
        HashSet<EnumDyeColor> requiredDyes = new HashSet<EnumDyeColor>();
        int craftAmount = Craftable instanceof EnumFlatBlockType ? Craftable.getOutputCount() : 1;
        EnumDyeColor alternateDye = EnumFlatColorAttributes.getAlternateDye(charistics);
        HashSet<EnumDyeColor> alternateSet = new HashSet<EnumDyeColor>();
        if (alternateDye != null) {
            alternateSet.add(alternateDye);
        }
        for (EnumFlatColorAttributes cc : charistics) {
            requiredDyes.add(cc.primaryDye);
            requiredDyes.add(cc.secondaryDye);
        }
        for (int x = 0; x < count && out.field_77994_a + craftAmount <= 64; ++x) {
            ItemCraftingSource is;
            ItemCraftingSource is2;
            boolean isGood = true;
            ItemCraftingSource isx = this.findItem(da.stacks.get((Object)Craftable), simulate);
            if (isx == null) {
                isGood = false;
            }
            HashSet<EnumDyeColor> usedSet = alternateSet;
            if (alternateDye == null || (is2 = this.findItem(da.stacks.get(alternateDye), simulate)) == null) {
                usedSet = requiredDyes;
                for (EnumDyeColor dye : requiredDyes) {
                    is = this.findItem(da.stacks.get(dye), simulate);
                    if (is != null) continue;
                    isGood = false;
                }
            }
            if (!isGood) break;
            for (EnumDyeColor dye : usedSet) {
                is = this.findItem(da.stacks.get(dye), simulate);
                is.consume(1);
            }
            isx.consume(1);
            out.field_77994_a += craftAmount;
        }
        this.updateContents();
        if (out.field_77994_a <= 0) {
            out = null;
        }
        return out;
    }

    private ItemCraftingSource findItem(HashSet<ItemCraftingSource> hashSet, boolean simulate) {
        for (ItemCraftingSource src : hashSet) {
            src.simulate = simulate;
            ItemStack is = src.getStack();
            if (is == null || is.field_77994_a <= 0) continue;
            return src;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.options.clear();
    }
}

