/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.fluid;

import mcjty.deepresonance.fluid.DRFluidRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public final class LiquidCrystalFluidTagData {
    private FluidStack referenceStack;
    private boolean valid;
    private float quality;
    private float purity;
    private float strength;
    private float efficiency;

    public static LiquidCrystalFluidTagData fromNBT(NBTTagCompound tag, int amount) {
        return LiquidCrystalFluidTagData.fromStack(new FluidStack(DRFluidRegistry.liquidCrystal, amount, tag));
    }

    public static FluidStack makeLiquidCrystalStack(int amount, float quality, float purity, float strength, float efficiency) {
        FluidStack stack = new FluidStack(DRFluidRegistry.liquidCrystal, amount);
        stack.tag = new NBTTagCompound();
        stack.tag.func_74776_a("quality", quality);
        stack.tag.func_74776_a("purity", purity);
        stack.tag.func_74776_a("strength", strength);
        stack.tag.func_74776_a("efficiency", efficiency);
        return stack;
    }

    public FluidStack makeLiquidCrystalStack() {
        FluidStack stack = new FluidStack(DRFluidRegistry.liquidCrystal, this.referenceStack.amount);
        stack.tag = new NBTTagCompound();
        stack.tag.func_74776_a("quality", this.quality);
        stack.tag.func_74776_a("purity", this.purity);
        stack.tag.func_74776_a("strength", this.strength);
        stack.tag.func_74776_a("efficiency", this.efficiency);
        return stack;
    }

    public static LiquidCrystalFluidTagData fromStack(FluidStack stack) {
        if (!DRFluidRegistry.isValidLiquidCrystalStack(stack)) {
            return null;
        }
        if (stack.tag == null) {
            stack.tag = new NBTTagCompound();
        }
        NBTTagCompound fluidTag = stack.tag;
        LiquidCrystalFluidTagData ret = LiquidCrystalFluidTagData.fromNBT(fluidTag);
        ret.valid = stack.amount > 0;
        ret.referenceStack = stack;
        return ret;
    }

    public static LiquidCrystalFluidTagData fromNBT(NBTTagCompound fluidTag) {
        if (fluidTag == null) {
            return null;
        }
        LiquidCrystalFluidTagData ret = new LiquidCrystalFluidTagData();
        ret.valid = true;
        ret.quality = fluidTag.func_74760_g("quality");
        ret.purity = fluidTag.func_74760_g("purity");
        ret.strength = fluidTag.func_74760_g("strength");
        ret.efficiency = fluidTag.func_74760_g("efficiency");
        return ret;
    }

    private LiquidCrystalFluidTagData() {
    }

    public void merge(LiquidCrystalFluidTagData otherTag) {
        this.checkNullity();
        if (!otherTag.valid) {
            return;
        }
        this.quality = this.calculate(otherTag, this.quality, otherTag.quality);
        this.purity = this.calculate(otherTag, this.purity, otherTag.purity);
        this.strength = this.calculate(otherTag, this.strength, otherTag.strength);
        this.efficiency = this.calculate(otherTag, this.efficiency, otherTag.efficiency);
        this.referenceStack.amount += otherTag.referenceStack.amount;
        this.save();
    }

    private float calculate(LiquidCrystalFluidTagData other, float myValue, float otherValue) {
        float f = (float)other.getInternalTankAmount() / ((float)this.getInternalTankAmount() + (float)other.getInternalTankAmount());
        return (1.0f - f) * myValue + f * otherValue;
    }

    public void save() {
        this.writeDataToNBT(this.referenceStack.tag);
    }

    public void writeDataToNBT(NBTTagCompound tagCompound) {
        this.checkNullity();
        tagCompound.func_74776_a("quality", this.quality);
        tagCompound.func_74776_a("purity", this.purity);
        tagCompound.func_74776_a("strength", this.strength);
        tagCompound.func_74776_a("efficiency", this.efficiency);
    }

    private void checkNullity() {
        if (this.referenceStack == null || this.referenceStack.amount <= 0) {
            this.valid = false;
            this.purity = 0.0f;
        } else if (!this.valid) {
            this.valid = true;
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public float getPurity() {
        return this.purity;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public int getInternalTankAmount() {
        return this.referenceStack.amount;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public void setPurity(float purity) {
        this.purity = purity;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public void setEfficiency(float efficiency) {
        this.efficiency = efficiency;
    }

    public void setInternalAmount(int i) {
        this.referenceStack.amount = i;
    }

    public FluidStack getReferenceStack() {
        return this.referenceStack.copy();
    }

    public String toString() {
        return "Amount: " + this.referenceStack.amount + " ,Quality: " + this.quality + " ,Purity: " + this.purity + " ,Strength: " + this.strength + " ,Efficiency: " + this.efficiency;
    }
}

