/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.client.sound;

import com.google.common.collect.Maps;
import elec332.core.util.RegistryHelper;
import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.client.DRResourceLocation;
import mcjty.deepresonance.client.sound.GeneratorSound;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GeneratorSoundController {
    private static final Map<GlobalCoordinate, GeneratorSound> sounds = Maps.newHashMap();
    protected static SoundEvent startup;
    protected static SoundEvent loop;
    protected static SoundEvent shutDown;

    public static void init() {
        startup = GeneratorSoundController.registerSound(new DRResourceLocation("engine_start"));
        loop = GeneratorSoundController.registerSound(new DRResourceLocation("engine_loop"));
        shutDown = GeneratorSoundController.registerSound(new DRResourceLocation("engine_shutdown"));
    }

    private static SoundEvent registerSound(ResourceLocation rl) {
        SoundEvent ret = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
        RegistryHelper.getSoundEventRegistry().register((IForgeRegistryEntry)ret);
        return ret;
    }

    public static void stopSound(World worldObj, BlockPos pos) {
        GlobalCoordinate g = GeneratorSoundController.fromPosition(worldObj, pos);
        if (sounds.containsKey(g)) {
            MovingSound movingSound = sounds.get(g);
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(g);
        }
    }

    private static void playSound(World worldObj, BlockPos pos, SoundEvent soundType) {
        GeneratorSound sound = new GeneratorSound(soundType, worldObj, pos);
        GeneratorSoundController.stopSound(worldObj, pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        GlobalCoordinate g = new GlobalCoordinate(pos, worldObj.field_73011_w.getDimension());
        sounds.put(g, sound);
    }

    public static void playStartup(World worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, startup);
    }

    public static void playLoop(World worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, loop);
    }

    public static void playShutdown(World worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, shutDown);
    }

    public static boolean isStartupPlaying(World worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt(startup, worldObj, pos);
    }

    public static boolean isLoopPlaying(World worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt(loop, worldObj, pos);
    }

    public static boolean isShutdownPlaying(World worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt(shutDown, worldObj, pos);
    }

    private static boolean isSoundTypePlayingAt(SoundEvent event, World world, BlockPos pos) {
        GeneratorSound s = GeneratorSoundController.getSoundAt(world, pos);
        return s != null && s.isSoundType(event);
    }

    private static GeneratorSound getSoundAt(World world, BlockPos pos) {
        return sounds.get(GeneratorSoundController.fromPosition(world, pos));
    }

    private static GlobalCoordinate fromPosition(World world, BlockPos pos) {
        return new GlobalCoordinate(pos, WorldHelper.getDimID((World)world));
    }
}

