/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import elec332.core.world.WorldHelper;
import java.util.Random;
import java.util.UUID;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ResonatingCrystalTileEntity
extends GenericTileEntity {
    private float strength = 1.0f;
    private float power = 1.0f;
    private float efficiency = 1.0f;
    private float purity = 1.0f;
    private float powerPerTick = -1.0f;
    private int rfPerTick = -1;
    private boolean glowing = false;

    public float getStrength() {
        return this.strength;
    }

    public float getPower() {
        return this.power;
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public float getPurity() {
        return this.purity;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setStrength(float strength) {
        this.strength = strength;
        this.markDirtyClient();
    }

    public boolean isEmpty() {
        return this.power < 1.0E-5f;
    }

    public void setPower(float power) {
        boolean oldempty = this.isEmpty();
        this.power = power;
        this.func_70296_d();
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            this.markDirtyClient();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldempty = this.isEmpty();
        super.onDataPacket(net, packet);
        boolean newempty = this.isEmpty();
        if (oldempty != newempty) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void setEfficiency(float efficiency) {
        this.efficiency = efficiency;
        this.markDirtyClient();
    }

    public void setPurity(float purity) {
        this.purity = purity;
        this.markDirtyClient();
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing == glowing) {
            return;
        }
        this.glowing = glowing;
        if (this.func_145831_w() != null) {
            this.markDirtyClient();
        } else {
            this.func_70296_d();
        }
    }

    public boolean setOwner(EntityPlayer player) {
        return false;
    }

    public String getOwnerName() {
        return "";
    }

    public UUID getOwnerUUID() {
        return null;
    }

    public float getPowerPerTick() {
        if (this.powerPerTick < 0.0f) {
            float totalRF = ResonatingCrystalTileEntity.getTotalPower(this.strength, this.purity);
            float numticks = totalRF / (float)this.getRfPerTick();
            this.powerPerTick = 100.0f / numticks;
        }
        return this.powerPerTick;
    }

    public static float getTotalPower(float strength, float purity) {
        return 1000.0f * (float)ConfigMachines.Power.maximumKiloRF * strength / 100.0f * (purity + 30.0f) / 130.0f;
    }

    public int getRfPerTick() {
        if (this.rfPerTick == -1) {
            this.rfPerTick = ResonatingCrystalTileEntity.getRfPerTick(this.efficiency, this.purity);
        }
        return this.rfPerTick;
    }

    public static int getRfPerTick(float efficiency, float purity) {
        return (int)((float)ConfigMachines.Power.maximumRFPerTick * efficiency / 100.1f * (purity + 2.0f) / 102.0f + 1.0f);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.strength = tagCompound.func_74760_g("strength");
        this.power = tagCompound.func_74760_g("power");
        this.efficiency = tagCompound.func_74760_g("efficiency");
        this.purity = tagCompound.func_74760_g("purity");
        this.glowing = tagCompound.func_74767_n("glowing");
        byte version = tagCompound.func_74771_c("version");
        if (version < 2) {
            this.power *= 20.0f;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74776_a("strength", this.strength);
        tagCompound.func_74776_a("power", this.power);
        tagCompound.func_74776_a("efficiency", this.efficiency);
        tagCompound.func_74776_a("purity", this.purity);
        tagCompound.func_74757_a("glowing", this.glowing);
        tagCompound.func_74774_a("version", (byte)2);
    }

    public static void spawnCrystal(EntityPlayer player, World world, BlockPos pos, int purity, int strength, int efficiency, int power) {
        WorldHelper.setBlockState((World)world, (BlockPos)pos, (IBlockState)ModBlocks.resonatingCrystalBlock.func_176203_a(0), (int)3);
        TileEntity te = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setPurity(purity);
            resonatingCrystalTileEntity.setStrength(strength);
            resonatingCrystalTileEntity.setEfficiency(efficiency);
            resonatingCrystalTileEntity.setPower(power);
            float radPurity = resonatingCrystalTileEntity.getPurity();
            float radRadius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getEfficiency(), radPurity);
            float radStrength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), radPurity);
            Logging.message((EntityPlayer)player, (String)("Crystal would produce " + radStrength + " radiation with a radius of " + radRadius));
        }
    }

    public static void spawnRandomCrystal(World world, Random random, BlockPos pos, int special) {
        WorldHelper.setBlockState((World)world, (BlockPos)pos, (IBlockState)ModBlocks.resonatingCrystalBlock.func_176203_a(0), (int)3);
        TileEntity te = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            if (special >= 5) {
                resonatingCrystalTileEntity.setStrength(1.0f);
                resonatingCrystalTileEntity.setPower(0.05f);
                resonatingCrystalTileEntity.setEfficiency(1.0f);
                resonatingCrystalTileEntity.setPurity(100.0f);
            } else if (special >= 3) {
                resonatingCrystalTileEntity.setStrength(100.0f);
                resonatingCrystalTileEntity.setPower(100.0f);
                resonatingCrystalTileEntity.setEfficiency(100.0f);
                resonatingCrystalTileEntity.setPurity(special == 4 ? 1.0f : 100.0f);
            } else {
                resonatingCrystalTileEntity.setStrength(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.01f);
                resonatingCrystalTileEntity.setPower(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 60.0f + 0.2f);
                resonatingCrystalTileEntity.setEfficiency(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 3.0f + 0.1f);
                resonatingCrystalTileEntity.setPurity(ResonatingCrystalTileEntity.getRandomSpecial(random, special) * 10.0f + 5.0f);
            }
        }
    }

    public static void spawnRandomCrystal(World world, Random random, BlockPos pos, float str, float pow, float eff, float pur) {
        WorldHelper.setBlockState((World)world, (BlockPos)pos, (IBlockState)ModBlocks.resonatingCrystalBlock.func_176203_a(0), (int)3);
        TileEntity te = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setStrength(random.nextFloat() * str * 3.0f + 0.01f);
            resonatingCrystalTileEntity.setPower(random.nextFloat() * pow * 60.0f + 0.2f);
            resonatingCrystalTileEntity.setEfficiency(random.nextFloat() * eff * 3.0f + 0.1f);
            resonatingCrystalTileEntity.setPurity(random.nextFloat() * pur * 10.0f + 5.0f);
        }
    }

    private static float getRandomSpecial(Random random, int special) {
        return special == 0 ? random.nextFloat() : (special == 1 ? 0.5f : 1.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

