/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.lexicon.GuiLexiconEntry;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.lexicon.page.PageText;

public class PageRecipe
extends LexiconPage {
    int relativeMouseX;
    int relativeMouseY;
    ItemStack tooltipStack;
    ItemStack tooltipContainerStack;
    boolean tooltipEntry;
    static boolean mouseDownLastTick = false;

    public PageRecipe(String unlocalizedName) {
        super(unlocalizedName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        this.relativeMouseX = mx;
        this.relativeMouseY = my;
        this.renderRecipe(gui, mx, my);
        int width = gui.getWidth() - 30;
        int height = gui.getHeight();
        int x = gui.getLeft() + 16;
        int y = gui.getTop() + height - 40;
        PageText.renderText(x, y, width, height, this.getUnlocalizedName());
        if (this.tooltipStack != null) {
            List tooltipData = this.tooltipStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            RenderHelper.renderTooltip(mx, my, parsedTooltip);
            int tooltipY = 8 + tooltipData.size() * 11;
            if (this.tooltipEntry) {
                RenderHelper.renderTooltipOrange(mx, my + tooltipY, Collections.singletonList(TextFormatting.GRAY + I18n.func_135052_a((String)"botaniamisc.clickToRecipe", (Object[])new Object[0])));
                tooltipY += 18;
            }
            if (this.tooltipContainerStack != null) {
                RenderHelper.renderTooltipGreen(mx, my + tooltipY, Arrays.asList(TextFormatting.AQUA + I18n.func_135052_a((String)"botaniamisc.craftingContainer", (Object[])new Object[0]), this.tooltipContainerStack.func_82833_r()));
            }
        }
        this.tooltipContainerStack = null;
        this.tooltipStack = null;
        this.tooltipEntry = false;
        GlStateManager.func_179084_k();
        mouseDownLastTick = Mouse.isButtonDown((int)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtAngle(IGuiLexiconEntry gui, float angle, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        ItemStack workStack = stack.func_77946_l();
        if (workStack.func_77952_i() == Short.MAX_VALUE || workStack.func_77952_i() == -1) {
            workStack.func_77964_b(0);
        }
        int radius = 32;
        double xPos = (double)gui.getLeft() + Math.cos((double)(angle -= 90.0f) * Math.PI / 180.0) * (double)radius + (double)(gui.getWidth() / 2) - 8.0;
        double yPos = (double)gui.getTop() + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + 53.0;
        this.renderItem(gui, xPos, yPos, workStack, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAtGridPos(IGuiLexiconEntry gui, int x, int y, ItemStack stack, boolean accountForContainer) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        if ((stack = stack.func_77946_l()).func_77952_i() == Short.MAX_VALUE) {
            stack.func_77964_b(0);
        }
        int xPos = gui.getLeft() + x * 29 + 7 + (y == 0 && x == 3 ? 10 : 0);
        int yPos = gui.getTop() + y * 29 + 24 - (y == 0 ? 7 : 0);
        ItemStack stack1 = stack.func_77946_l();
        if (stack1.func_77952_i() == -1) {
            stack1.func_77964_b(0);
        }
        this.renderItem(gui, xPos, yPos, stack1, accountForContainer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IGuiLexiconEntry gui, double xPos, double yPos, ItemStack stack, boolean accountForContainer) {
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        boolean mouseDown = Mouse.isButtonDown((int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)xPos, (double)yPos, (double)0.0);
        render.func_180450_b(stack, 0, 0);
        render.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0);
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        int xpi = (int)xPos;
        int ypi = (int)yPos;
        if (this.relativeMouseX >= xpi && this.relativeMouseY >= ypi && this.relativeMouseX <= xpi + 16 && this.relativeMouseY <= ypi + 16) {
            ItemStack containerStack;
            this.tooltipStack = stack;
            LexiconRecipeMappings.EntryData data = LexiconRecipeMappings.getDataForStack(this.tooltipStack);
            ItemStack book = PlayerHelper.getFirstHeldItemClass((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ILexicon.class);
            if (data != null && (data.entry != gui.getEntry() || data.page != gui.getPageOn()) && book != null && ((ILexicon)book.func_77973_b()).isKnowledgeUnlocked(book, data.entry.getKnowledgeType())) {
                this.tooltipEntry = true;
                if (!mouseDownLastTick && mouseDown && GuiScreen.func_146272_n()) {
                    GuiLexiconEntry newGui = new GuiLexiconEntry(data.entry, (GuiScreen)gui);
                    newGui.page = data.page;
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)newGui);
                }
            } else {
                this.tooltipEntry = false;
            }
            if (accountForContainer && (containerStack = stack.func_77973_b().getContainerItem(stack)) != null && containerStack.func_77973_b() != null) {
                this.tooltipContainerStack = containerStack;
            }
        }
        GlStateManager.func_179140_f();
    }
}

