/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCacophonium;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lib.LibObfuscation;

public class ItemCacophonium
extends ItemMod
implements ICraftAchievement {
    private static final String TAG_SOUND = "sound";
    private static final String TAG_SOUND_NAME = "soundName";

    public ItemCacophonium() {
        super("cacophonium");
        this.func_77625_d(1);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            SoundEvent sound = null;
            if (living instanceof EntityCreeper) {
                sound = SoundEvents.field_187572_ar;
            } else if (living instanceof EntitySlime) {
                sound = ((EntitySlime)living).func_189101_db() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
            } else {
                try {
                    sound = (SoundEvent)ReflectionHelper.findMethod(EntityLiving.class, (Object)living, (String[])LibObfuscation.GET_LIVING_SOUND, (Class[])new Class[0]).invoke((Object)living, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException ignored) {
                    Botania.LOGGER.debug("Couldn't get living sound");
                }
            }
            if (sound != null) {
                String s = EntityList.func_75621_b((Entity)entity);
                if (s == null) {
                    s = "generic";
                }
                ItemNBTHelper.setString(stack, TAG_SOUND, sound.getRegistryName().toString());
                ItemNBTHelper.setString(stack, TAG_SOUND_NAME, "entity." + s + ".name");
                player.func_184611_a(hand, stack);
                if (player.field_70170_p.field_72995_K) {
                    player.func_184609_a(hand);
                }
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xs, float ys, float zs) {
        Block block;
        if (ItemCacophonium.getSound(stack) != null && (block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150323_B) {
            world.func_175656_a(pos, ModBlocks.cacophonium.func_176223_P());
            ((TileCacophonium)world.func_175625_s((BlockPos)pos)).stack = stack.func_77946_l();
            --stack.field_77994_a;
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean adv) {
        if (ItemCacophonium.isDOIT(stack)) {
            list.add(I18n.func_135052_a((String)"botaniamisc.justDoIt", (Object[])new Object[0]));
        } else if (ItemCacophonium.getSound(stack) != null) {
            list.add(I18n.func_135052_a((String)ItemNBTHelper.getString(stack, TAG_SOUND_NAME, ""), (Object[])new Object[0]));
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (ItemCacophonium.getSound(stack) != null) {
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (count % (ItemCacophonium.isDOIT(stack) ? 20 : 6) == 0) {
            ItemCacophonium.playSound(player.field_70170_p, stack, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 0.9f);
        }
    }

    public static void playSound(World world, ItemStack stack, double x, double y, double z, SoundCategory category, float volume) {
        if (stack == null) {
            return;
        }
        SoundEvent sound = ItemCacophonium.getSound(stack);
        if (sound != null) {
            world.func_184148_a(null, x, y, z, sound, category, volume, sound == BotaniaSoundEvents.doit ? 1.0f : (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    private static SoundEvent getSound(ItemStack stack) {
        if (ItemCacophonium.isDOIT(stack)) {
            return BotaniaSoundEvents.doit;
        }
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(ItemNBTHelper.getString(stack, TAG_SOUND, "")));
    }

    private static boolean isDOIT(ItemStack stack) {
        return stack != null && stack.func_82833_r().equalsIgnoreCase("shia labeouf");
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.cacophoniumCraft;
    }
}

