/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class InventoryHelper {
    public static InvWithLocation getInventoryWithLocation(World world, BlockPos pos, EnumFacing side) {
        IItemHandler ret = InventoryHelper.getInventory(world, pos, side);
        if (ret == null) {
            return null;
        }
        return new InvWithLocation(ret, world, pos);
    }

    public static IItemHandler getInventory(World world, BlockPos pos, EnumFacing side) {
        IItemHandler ret;
        VanillaDoubleChestItemHandler doubleChest;
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (te instanceof TileEntityChest && (doubleChest = VanillaDoubleChestItemHandler.get((TileEntityChest)((TileEntityChest)te))) != VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
            return doubleChest;
        }
        IItemHandler iItemHandler = ret = te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (ret == null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            ret = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return ret;
    }

    public static void dropInventory(TileSimpleInventory inv, World world, IBlockState state, BlockPos pos) {
        if (inv != null) {
            for (int j1 = 0; j1 < inv.getSizeInventory(); ++j1) {
                ItemStack itemstack = inv.getItemHandler().getStackInSlot(j1);
                if (itemstack == null) continue;
                net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
            }
            world.func_175666_e(pos, state.func_177230_c());
        }
    }

    public static void withdrawFromInventory(TileSimpleInventory inv, EntityPlayer player) {
        for (int i = inv.getSizeInventory() - 1; i >= 0; --i) {
            ItemStack stackAt = inv.getItemHandler().getStackInSlot(i);
            if (stackAt == null) continue;
            ItemStack copy = stackAt.func_77946_l();
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)copy);
            inv.getItemHandler().setStackInSlot(i, null);
            player.field_70170_p.func_175666_e(inv.func_174877_v(), null);
            break;
        }
    }
}

