/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileMod;

public class TileCorporeaRetainer
extends TileMod {
    private static final String TAG_PENDING_REQUEST = "pendingRequest";
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_CONTENTS = "requestContents";
    private static final String TAG_REQUEST_STACK = "requestStack";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final int REQUEST_NULL = 0;
    private static final int REQUEST_ITEMSTACK = 1;
    private static final int REQUEST_STRING = 2;
    boolean pendingRequest = false;
    BlockPos requestPos = BlockPos.field_177992_a;
    Object request;
    int requestCount;

    public void setPendingRequest(BlockPos pos, Object request, int requestCount) {
        if (this.pendingRequest) {
            return;
        }
        this.requestPos = pos;
        this.request = request;
        this.requestCount = requestCount;
        this.pendingRequest = true;
        this.field_145850_b.func_175666_e(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c());
    }

    public boolean hasPendingRequest() {
        return this.pendingRequest;
    }

    public void fulfilRequest() {
        InvWithLocation inv;
        if (!this.hasPendingRequest()) {
            return;
        }
        ICorporeaSpark spark = CorporeaHelper.getSparkForBlock(this.field_145850_b, this.requestPos);
        if (spark != null && (inv = spark.getSparkInventory()) != null && inv.world.func_175625_s(inv.pos) instanceof ICorporeaRequestor) {
            ICorporeaRequestor requestor = (ICorporeaRequestor)inv.world.func_175625_s(inv.pos);
            requestor.doCorporeaRequest(this.request, this.requestCount, spark);
            this.pendingRequest = false;
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c());
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74757_a(TAG_PENDING_REQUEST, this.pendingRequest);
        cmp.func_74768_a(TAG_REQUEST_X, this.requestPos.func_177958_n());
        cmp.func_74768_a(TAG_REQUEST_Y, this.requestPos.func_177956_o());
        cmp.func_74768_a(TAG_REQUEST_Z, this.requestPos.func_177952_p());
        int reqType = 0;
        if (this.request != null) {
            reqType = this.request instanceof String ? 2 : 1;
        }
        cmp.func_74768_a(TAG_REQUEST_TYPE, reqType);
        switch (reqType) {
            case 2: {
                cmp.func_74778_a(TAG_REQUEST_CONTENTS, (String)this.request);
                break;
            }
            case 1: {
                NBTTagCompound cmp1 = new NBTTagCompound();
                ((ItemStack)this.request).func_77955_b(cmp1);
                cmp.func_74782_a(TAG_REQUEST_STACK, (NBTBase)cmp1);
                break;
            }
        }
        cmp.func_74768_a(TAG_REQUEST_COUNT, this.requestCount);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        super.readPacketNBT(cmp);
        this.pendingRequest = cmp.func_74767_n(TAG_PENDING_REQUEST);
        int x = cmp.func_74762_e(TAG_REQUEST_X);
        int y = cmp.func_74762_e(TAG_REQUEST_Y);
        int z = cmp.func_74762_e(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        int reqType = cmp.func_74762_e(TAG_REQUEST_TYPE);
        switch (reqType) {
            case 2: {
                this.request = cmp.func_74779_i(TAG_REQUEST_CONTENTS);
                break;
            }
            case 1: {
                NBTTagCompound cmp1 = cmp.func_74775_l(TAG_REQUEST_STACK);
                this.request = ItemStack.func_77949_a((NBTTagCompound)cmp1);
                break;
            }
        }
        this.requestCount = cmp.func_74762_e(TAG_REQUEST_COUNT);
    }
}

