/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.common.block.tile.TileMod;

public abstract class TileSimpleInventory
extends TileMod {
    protected SimpleItemStackHandler itemHandler = this.createItemHandler();

    @Override
    public void readPacketNBT(NBTTagCompound par1NBTTagCompound) {
        this.itemHandler = this.createItemHandler();
        this.itemHandler.deserializeNBT(par1NBTTagCompound);
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_179237_a(this.itemHandler.serializeNBT());
    }

    public abstract int getSizeInventory();

    protected SimpleItemStackHandler createItemHandler() {
        return new SimpleItemStackHandler(this, true);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nonnull EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nonnull EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return (T)super.getCapability(cap, side);
    }

    protected static class SimpleItemStackHandler
    extends ItemStackHandler {
        private final boolean allowWrite;
        private final TileSimpleInventory tile;

        public SimpleItemStackHandler(TileSimpleInventory inv, boolean allowWrite) {
            super(inv.getSizeInventory());
            this.allowWrite = allowWrite;
            this.tile = inv;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.allowWrite) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.allowWrite) {
                return super.extractItem(slot, amount, simulate);
            }
            return null;
        }

        public void onContentsChanged(int slot) {
            this.tile.func_70296_d();
        }
    }
}

