/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.client.gui.crafting.ContainerCraftingHalo;
import vazkii.botania.client.integration.jei.brewery.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.brewery.BreweryRecipeHandler;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeHandler;
import vazkii.botania.client.integration.jei.manapool.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.manapool.ManaPoolRecipeHandler;
import vazkii.botania.client.integration.jei.petalapothecary.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.petalapothecary.PetalApothecaryRecipeHandler;
import vazkii.botania.client.integration.jei.puredaisy.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.puredaisy.PureDaisyRecipeHandler;
import vazkii.botania.client.integration.jei.runicaltar.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.runicaltar.RunicAltarRecipeHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

@JEIPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        jeiHelpers.getSubtypeRegistry().registerNbtInterpreter(Item.func_150898_a((Block)ModBlocks.specialFlower), ItemBlockSpecialFlower::getType);
        jeiHelpers.getSubtypeRegistry().registerNbtInterpreter(Item.func_150898_a((Block)ModBlocks.floatingSpecialFlower), ItemBlockSpecialFlower::getType);
        registry.addRecipeCategories(new IRecipeCategory[]{new BreweryRecipeCategory(jeiHelpers.getGuiHelper()), new PureDaisyRecipeCategory(jeiHelpers.getGuiHelper()), new RunicAltarRecipeCategory(jeiHelpers.getGuiHelper()), new PetalApothecaryRecipeCategory(jeiHelpers.getGuiHelper()), new ElvenTradeRecipeCategory(jeiHelpers.getGuiHelper()), new ManaPoolRecipeCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BreweryRecipeHandler(), new PureDaisyRecipeHandler(), new RunicAltarRecipeHandler(), new PetalApothecaryRecipeHandler(), new ElvenTradeRecipeHandler(), new ManaPoolRecipeHandler()});
        registry.addRecipes(BotaniaAPI.brewRecipes);
        registry.addRecipes(BotaniaAPI.pureDaisyRecipes);
        registry.addRecipes(BotaniaAPI.petalRecipes);
        registry.addRecipes(BotaniaAPI.elvenTradeRecipes);
        registry.addRecipes(BotaniaAPI.runeAltarRecipes);
        registry.addRecipes(BotaniaAPI.manaInfusionRecipes);
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.brewery), new String[]{"botania.brewery"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.alfPortal), new String[]{"botania.elvenTrade"});
        for (PoolVariant poolVariant : PoolVariant.values()) {
            registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.pool, 1, poolVariant.ordinal()), new String[]{"botania.manaPool"});
        }
        for (Enum enum_ : AltarVariant.values()) {
            if (enum_ == AltarVariant.MOSSY) continue;
            registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.altar, 1, enum_.ordinal()), new String[]{"botania.petals"});
        }
        registry.addRecipeCategoryCraftingItem(ItemBlockSpecialFlower.ofType("puredaisy"), new String[]{"botania.pureDaisy"});
        registry.addRecipeCategoryCraftingItem(ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), "puredaisy"), new String[]{"botania.pureDaisy"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.runeAltar), new String[]{"botania.runicAltar"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModItems.autocraftingHalo), new String[]{"minecraft.crafting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModItems.craftingHalo), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerCraftingHalo.class, "minecraft.crafting", 1, 9, 10, 36);
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }
}

