/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.items;

import com.mrdimka.solarfluxreborn.blocks.DraconicSolarPanelBlock;
import com.mrdimka.solarfluxreborn.blocks.SolarPanelBlock;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.utility.Color;
import com.mrdimka.solarfluxreborn.utility.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class SolarPanelItemBlock
extends ItemBlock {
    public SolarPanelItemBlock(Block pBlock) {
        super(pBlock);
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pPlayer, List pList, boolean pBoolean) {
        super.func_77624_a(pItemStack, pPlayer, pList, pBoolean);
        this.addChargeTooltip(pList, pItemStack);
        this.addUpgradeCount(pList, pItemStack);
        if (this.func_179223_d() instanceof SolarPanelBlock) {
            SolarPanelBlock solar = (SolarPanelBlock)this.func_179223_d();
            this.addCapacityTooltip(pList, pItemStack, solar);
            this.addGenerationTooltip(pList, pItemStack, solar);
            this.addTransferTooltip(pList, pItemStack, solar);
        } else if (this.func_179223_d() instanceof DraconicSolarPanelBlock) {
            DraconicSolarPanelBlock solar = (DraconicSolarPanelBlock)this.func_179223_d();
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.capacity"), Color.GREY, solar.cap}));
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.generation"), Color.GREY, solar.maxGen}));
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.transfer"), Color.GREY, solar.transfer}));
            if (pItemStack.func_77942_o() && pItemStack.func_77978_p().func_150297_b("MaxGen", 3) && pItemStack.func_77978_p().func_74762_e("MaxGen") != solar.maxGen) {
                pList.add((Object)((Object)Color.AQUA) + "MaxGen: " + (Object)((Object)Color.GREY) + pItemStack.func_77978_p().func_74762_e("MaxGen"));
            }
        }
    }

    private void addChargeTooltip(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFREnergy")) {
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.GREEN, Lang.localise("energy.stored"), Color.GREY, pItemStack.func_77978_p().func_74762_e("SFREnergy")}));
        }
    }

    private void addUpgradeCount(List pList, ItemStack pItemStack) {
        if (this.hasNbtTag(pItemStack, "SFRTLUpgradeCount")) {
            pList.add(String.format("%s%s:%s %,d", new Object[]{Color.GREEN, Lang.localise("upgrades.installed"), Color.GREY, pItemStack.func_77978_p().func_74762_e("SFRTLUpgradeCount")}));
        }
    }

    private void addCapacityTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getCapacity();
        if (this.hasNbtTag(pItemStack, "SFRTLCapacity") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFRTLCapacity")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.capacity"), Color.GREY, value}));
    }

    private void addGenerationTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyGeneration();
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.generation"), Color.GREY, value}));
    }

    private void addTransferTooltip(List pList, ItemStack pItemStack, SolarPanelBlock pSolar) {
        int itemValue;
        int value = ModConfiguration.getTierConfiguration(pSolar.getTierIndex()).getMaximumEnergyTransfer();
        if (this.hasNbtTag(pItemStack, "SFRTLTransferRate") && (itemValue = pItemStack.func_77978_p().func_74762_e("SFRTLTransferRate")) != value) {
            value = itemValue;
        }
        pList.add(String.format("%s%s:%s %,d", new Object[]{Color.AQUA, Lang.localise("energy.transfer"), Color.GREY, value}));
    }

    private boolean hasNbtTag(ItemStack pItemStack, String pNbtTag) {
        return pItemStack.func_77942_o() && pItemStack.func_77978_p().func_74764_b(pNbtTag);
    }
}

