/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mrdimka.solarfluxreborn.SolarFluxRebornMod;
import com.mrdimka.solarfluxreborn.blocks.BlockCable320;
import com.mrdimka.solarfluxreborn.blocks.BlockCable3200;
import com.mrdimka.solarfluxreborn.blocks.BlockCable320000;
import com.mrdimka.solarfluxreborn.config.DraconicEvolutionConfigs;
import com.mrdimka.solarfluxreborn.config.TierConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfiguration {
    public static final List<TierConfiguration> DEFAULT_TIER_CONFIGURATIONS = ImmutableList.of((Object)new TierConfiguration(1, 25000), (Object)new TierConfiguration(8, 125000), (Object)new TierConfiguration(32, 425000), (Object)new TierConfiguration(128, 2000000), (Object)new TierConfiguration(512, 8000000), (Object)new TierConfiguration(2048, 32000000), (Object)new TierConfiguration(8192, 64000, 64000000), (Object)new TierConfiguration(32768, 256000, 128000000));
    private static final String UPGRADE_CATEGORY = "upgrades";
    private static Configuration cfg;
    private static boolean autoBalanceEnergy;
    private static boolean keepEnergyWhenDismantled;
    private static boolean keepInventoryWhenDismantled;
    private static float rainGenerationFactor;
    private static float thunderGenerationFactor;
    private static List<TierConfiguration> mTierConfigurations;
    private static boolean mEfficiencyUpgradeActive;
    private static float mEfficiencyUpgradeIncrease;
    private static float mEfficiencyUpgradeReturnsToScale;
    private static int mEfficiencyUpgradeMax;
    private static boolean mLowLightUpgradeActive;
    private static int mLowLightUpgradeMax;
    private static boolean mTraversalUpgradeActive;
    private static int mTraversalUpgradeIncrease;
    private static int mTraversalUpgradeUpdateRate;
    private static int mTraversalUpgradeMax;
    private static boolean mTransferRateUpgradeActive;
    private static float mTransferRateUpgradeIncrease;
    private static float mTransferRateUpgradeReturnsToScale;
    private static int mTransferRateUpgradeMax;
    private static boolean mCapacityUpgradeActive;
    private static float mCapacityUpgradeIncrease;
    private static float mCapacityUpgradeReturnsToScale;
    private static int mCapacityUpgradeMax;
    private static boolean mFurnaceUpgradeActive;
    private static int mFurnaceUpgradeHeatingConsumption;
    private static boolean mConnectedTextures;
    public static boolean wasConfigReplaced;
    public static boolean willNotify;

    public static void initialize(File pConfigFile, File versionFile) {
        String version = "";
        try {
            FileInputStream i = new FileInputStream(versionFile);
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)i);
            version = nbt.func_74779_i("version");
            ((InputStream)i).close();
        }
        catch (Throwable err) {
            ModConfiguration.saveUpdateVersionDat(versionFile);
        }
        if (!"2.13r".equals(version)) {
            pConfigFile.renameTo(new File(SolarFluxRebornMod.cfgFolder, "main.cfg.old"));
            wasConfigReplaced = true;
            willNotify = true;
            ModConfiguration.saveUpdateVersionDat(versionFile);
        }
        if (cfg == null) {
            cfg = new Configuration(pConfigFile);
        }
        MinecraftForge.EVENT_BUS.register((Object)new ModConfiguration());
        MinecraftForge.EVENT_BUS.register((Object)new DraconicEvolutionConfigs());
        ModConfiguration.loadConfiguration();
    }

    private static void saveUpdateVersionDat(File version) {
        try {
            if (!version.isFile()) {
                version.createNewFile();
            }
            FileOutputStream o = new FileOutputStream(version);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("version", "2.13r");
            nbt.func_74757_a("willNotify", willNotify);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)o);
            o.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void updateNotification(boolean willNotify) {
        ModConfiguration.willNotify = willNotify;
        ModConfiguration.saveUpdateVersionDat(new File(SolarFluxRebornMod.cfgFolder, "version.dat"));
    }

    private static void loadConfiguration() {
        if (cfg == null) {
            ModConfiguration.initialize(new File(SolarFluxRebornMod.cfgFolder, "main.cfg"), new File(SolarFluxRebornMod.cfgFolder, "version.dat"));
        }
        autoBalanceEnergy = cfg.getBoolean("BalanceEnergy", "general", true, "Neighbor solar panels share their energy if set to true.");
        keepEnergyWhenDismantled = cfg.getBoolean("KeepEnergyWhenDismantled", "general", true, "Whether or not the solar panels keep their internal energy when dismantled with a wrench.");
        keepInventoryWhenDismantled = cfg.getBoolean("KeepInventoryWhenDismantled", "general", true, "Whether or not the solar panels keep their internal inventory when dismantled with a wrench.");
        rainGenerationFactor = cfg.getFloat("RainProductionFactor", "general", 0.4f, 0.0f, 1.0f, "Factor used to reduce the energy generation during rainy weather.");
        thunderGenerationFactor = cfg.getFloat("ThunderProductionFactor", "general", 0.4f, 0.0f, 1.0f, "Factor used to reduce the energy generation during stormy weather.");
        mConnectedTextures = cfg.getBoolean("ConnectedTextures", "general", true, "Use connected textures for the solar panels.");
        ModConfiguration.loadTierConfigurations();
        ModConfiguration.loadUpgradesConfiguration();
        BlockCable320.TRANSFER_RATE = cfg.getFloat("cable t1", "cables", 320.0f, 1.0f, 1000000.0f, "How much RF can first cable transfer.");
        BlockCable3200.TRANSFER_RATE = cfg.getFloat("cable t2", "cables", 3200.0f, 1.0f, 1000000.0f, "How much RF can second cable transfer.");
        BlockCable320000.TRANSFER_RATE = cfg.getFloat("cable t3", "cables", 320000.0f, 1.0f, 1000000.0f, "How much RF can last cable transfer.");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static void loadUpgradesConfiguration() {
        mEfficiencyUpgradeActive = cfg.getBoolean("EfficiencyUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not efficiency upgrades should be added to the game.");
        mEfficiencyUpgradeIncrease = cfg.getFloat("EfficiencyUpgradeIncrease", UPGRADE_CATEGORY, 0.05f, 0.01f, 10.0f, "Factor by which the energy production is increased per upgrade.");
        mEfficiencyUpgradeReturnsToScale = cfg.getFloat("EfficiencyUpgradeReturnsToScale", UPGRADE_CATEGORY, 0.9f, 0.1f, 2.0f, "Returns to scale. How does the efficiency scales as you add more upgrades. 1 is linear. Below 1 reduces the efficiency as you add upgrades, Above 1 does the opposite.");
        mEfficiencyUpgradeMax = cfg.getInt("EfficiencyUpgradeMax", UPGRADE_CATEGORY, 8, 1, 256, "Maximum number of efficiency upgrade that can be added to a single solar panel.");
        mLowLightUpgradeActive = cfg.getBoolean("LowLightUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not low light upgrades should be added to the game.");
        mLowLightUpgradeMax = cfg.getInt("LowLightUpgradeMax", UPGRADE_CATEGORY, 8, 1, 256, "Maximum number of low light upgrade that can be added to a single solar panel.");
        mTraversalUpgradeActive = cfg.getBoolean("TraversalUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not traversal upgrades should be added to the game.");
        mTraversalUpgradeIncrease = cfg.getInt("TraversalUpgradeIncrease", UPGRADE_CATEGORY, 1, 1, 10, "How many extra machines can be traversed per extra upgrade.");
        mTraversalUpgradeUpdateRate = cfg.getInt("TraversalUpgradeUpdateRate", UPGRADE_CATEGORY, 25, 1, 1200, "Update rate of traversal. Increase to reduce lag. But machines will be discovered slower.");
        mTraversalUpgradeMax = cfg.getInt("TraversalUpgradeMax", UPGRADE_CATEGORY, 64, 1, 256, "Maximum number of traversal upgrade that can be added to a single solar panel.");
        mTransferRateUpgradeActive = cfg.getBoolean("TransferRateUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not transfer rate upgrades should be added to the game.");
        mTransferRateUpgradeIncrease = cfg.getFloat("TransferRateUpgradeIncrease", UPGRADE_CATEGORY, 0.1f, 0.01f, 10.0f, "Factor by which the transfer rate is increased per upgrade.");
        mTransferRateUpgradeReturnsToScale = cfg.getFloat("TransferRateUpgradeReturnsToScale", UPGRADE_CATEGORY, 0.9f, 0.1f, 2.0f, "Returns to scale. How does the transfer rate scales as you add more upgrades. 1 is linear. Below 1 reduces the efficiency as you add upgrades, Above 1 does the opposite.");
        mTransferRateUpgradeMax = cfg.getInt("TransferRateUpgradeMax", UPGRADE_CATEGORY, 8, 1, 256, "Maximum number of transfer rate upgrade that can be added to a single solar panel.");
        mCapacityUpgradeActive = cfg.getBoolean("CapacityUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not capacity upgrades should be added to the game.");
        mCapacityUpgradeIncrease = cfg.getFloat("CapacityUpgradeIncrease", UPGRADE_CATEGORY, 0.1f, 0.01f, 10.0f, "Factor by which the capacity is increased per upgrade.");
        mCapacityUpgradeReturnsToScale = cfg.getFloat("CapacityUpgradeReturnsToScale", UPGRADE_CATEGORY, 1.0f, 0.1f, 2.0f, "Returns to scale. How does the transfer rate scales as you add more upgrades. 1 is linear. Below 1 reduces the efficiency as you add upgrades, Above 1 does the opposite.");
        mCapacityUpgradeMax = cfg.getInt("CapacityUpgradeMax", UPGRADE_CATEGORY, 16, 1, 256, "Maximum number of capacity upgrade that can be added to a single solar panel.");
        mFurnaceUpgradeActive = cfg.getBoolean("FurnaceUpgradeActive", UPGRADE_CATEGORY, true, "Whether or not furnace upgrades should be added to the game.");
        mFurnaceUpgradeHeatingConsumption = cfg.getInt("FurnaceUpgradeHeatingConsumption", UPGRADE_CATEGORY, 8, 1, 64000, "Amount of RF per tick used to heat up a furnace.");
    }

    private static void loadTierConfigurations() {
        TierConfiguration config;
        mTierConfigurations = Lists.newArrayList();
        int tier = 0;
        while ((config = ModConfiguration.loadTierConfiguration(tier)) != null) {
            mTierConfigurations.add(config);
            ++tier;
        }
    }

    private static TierConfiguration loadTierConfiguration(int pTierNumber) {
        String category = "solar_panel_tier" + pTierNumber;
        boolean active = cfg.getBoolean("Active", category, pTierNumber < DEFAULT_TIER_CONFIGURATIONS.size(), "Whether or not this tier of Solar Panel should be added to the game.");
        if (active) {
            TierConfiguration defaultConfig;
            if (pTierNumber < DEFAULT_TIER_CONFIGURATIONS.size()) {
                defaultConfig = DEFAULT_TIER_CONFIGURATIONS.get(pTierNumber);
            } else {
                int deltaTier = pTierNumber - DEFAULT_TIER_CONFIGURATIONS.size() + 1;
                TierConfiguration lastConfig = DEFAULT_TIER_CONFIGURATIONS.get(DEFAULT_TIER_CONFIGURATIONS.size() - 1);
                defaultConfig = new TierConfiguration((int)((double)lastConfig.getMaximumEnergyGeneration() * Math.pow(2.0, deltaTier)), (int)((double)lastConfig.getMaximumEnergyTransfer() * Math.pow(2.0, deltaTier)), (int)((double)lastConfig.getCapacity() * Math.pow(1.2, deltaTier)));
            }
            return new TierConfiguration(cfg.getInt("MaximumEnergyGeneration", category, defaultConfig.getMaximumEnergyGeneration(), 1, 2000000000, "Maximum amount of RF generated per tick."), cfg.getInt("MaximumEnergyTransfer", category, defaultConfig.getMaximumEnergyTransfer(), 1, 2000000000, "Maximum amount of RF transferred per tick."), cfg.getInt("Capacity", category, defaultConfig.getCapacity(), 1, 2000000000, "Amount of RF that can be stored."));
        }
        return null;
    }

    public static Configuration getConfiguration() {
        return cfg;
    }

    public static boolean doesAutoBalanceEnergy() {
        return autoBalanceEnergy;
    }

    public static boolean doesKeepEnergyWhenDismantled() {
        return keepEnergyWhenDismantled;
    }

    public static boolean doesKeepInventoryWhenDismantled() {
        return keepInventoryWhenDismantled;
    }

    public static float getRainGenerationFactor() {
        return rainGenerationFactor;
    }

    public static float getThunderGenerationFactor() {
        return thunderGenerationFactor;
    }

    public static List<TierConfiguration> getTierConfigurations() {
        return mTierConfigurations;
    }

    public static TierConfiguration getTierConfiguration(int pTierIndex) {
        return mTierConfigurations.get(pTierIndex);
    }

    public static boolean isEfficiencyUpgradeActive() {
        return mEfficiencyUpgradeActive;
    }

    public static float getEfficiencyUpgradeIncrease() {
        return mEfficiencyUpgradeIncrease;
    }

    public static int getEfficiencyUpgradeMax() {
        return mEfficiencyUpgradeMax;
    }

    public static float getEfficiencyUpgradeReturnsToScale() {
        return mEfficiencyUpgradeReturnsToScale;
    }

    public static boolean isLowLightUpgradeActive() {
        return mLowLightUpgradeActive;
    }

    public static int getLowLightUpgradeMax() {
        return mLowLightUpgradeMax;
    }

    public static boolean isTraversalUpgradeActive() {
        return mTraversalUpgradeActive;
    }

    public static int getTraversalUpgradeIncrease() {
        return mTraversalUpgradeIncrease;
    }

    public static int getTraversalUpgradeMax() {
        return mTraversalUpgradeMax;
    }

    public static int getTraversalUpgradeUpdateRate() {
        return mTraversalUpgradeUpdateRate;
    }

    public static boolean isTransferRateUpgradeActive() {
        return mTransferRateUpgradeActive;
    }

    public static float getTransferRateUpgradeIncrease() {
        return mTransferRateUpgradeIncrease;
    }

    public static int getTransferRateUpgradeMax() {
        return mTransferRateUpgradeMax;
    }

    public static float getTransferRateUpgradeReturnsToScale() {
        return mTransferRateUpgradeReturnsToScale;
    }

    public static boolean isCapacityUpgradeActive() {
        return mCapacityUpgradeActive;
    }

    public static float getCapacityUpgradeIncrease() {
        return mCapacityUpgradeIncrease;
    }

    public static int getCapacityUpgradeMax() {
        return mCapacityUpgradeMax;
    }

    public static float getCapacityUpgradeReturnsToScale() {
        return mCapacityUpgradeReturnsToScale;
    }

    public static boolean isFurnaceUpgradeActive() {
        return mFurnaceUpgradeActive;
    }

    public static int getFurnaceUpgradeHeatingConsumption() {
        return mFurnaceUpgradeHeatingConsumption;
    }

    public static boolean useConnectedTextures() {
        return mConnectedTextures;
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent pEvent) {
        if (pEvent.getModID().equalsIgnoreCase("solarfluxreborn")) {
            ModConfiguration.loadConfiguration();
        }
    }

    static {
        wasConfigReplaced = false;
        willNotify = false;
    }
}

