/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.PacketTargetsReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetTargets
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<PacketGetTargets, IMessage> {
        public IMessage onMessage(PacketGetTargets message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetTargets message, MessageContext ctx) {
            int i;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemStackTools.isEmpty((ItemStack)heldItem)) {
                return;
            }
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            int target = -1;
            int[] targets = new int[8];
            String[] names = new String[8];
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.func_130014_f_());
            if (tagCompound != null) {
                target = tagCompound.func_74764_b("target") ? tagCompound.func_74762_e("target") : -1;
                for (i = 0; i < 8; ++i) {
                    names[i] = "";
                    if (tagCompound.func_74764_b("target" + i)) {
                        TeleportDestination destination;
                        targets[i] = tagCompound.func_74762_e("target" + i);
                        GlobalCoordinate gc = destinations.getCoordinateForId(targets[i]);
                        if (gc == null || (destination = destinations.getDestination(gc)) == null) continue;
                        names[i] = destination.getName() + " (dimension " + destination.getDimension() + ")";
                        continue;
                    }
                    targets[i] = -1;
                }
            } else {
                for (i = 0; i < 8; ++i) {
                    targets[i] = -1;
                    names[i] = "";
                }
            }
            PacketTargetsReady msg = new PacketTargetsReady(target, targets, names);
            RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
        }
    }
}

