/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.Set;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.storagemonitor.SearchItemsInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SearchItemsInfoPacketServer
implements InfoPacketServer {
    private int id;
    private BlockPos pos;
    private String text;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
        this.text = NetworkTools.readString((ByteBuf)byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        byteBuf.writeInt(this.id);
        NetworkTools.writeString((ByteBuf)byteBuf, (String)this.text);
    }

    public SearchItemsInfoPacketServer() {
    }

    public SearchItemsInfoPacketServer(int worldId, BlockPos pos, String text) {
        this.id = worldId;
        this.pos = pos;
        this.text = text;
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Set<BlockPos> inventories = scannerTileEntity.performSearch(this.text);
            return Optional.of(new SearchItemsInfoPacketClient(inventories));
        }
        return Optional.empty();
    }
}

