/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.util.List;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.tools.MinecraftTools;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import mcjty.rftools.blocks.screens.modules.ElevatorButtonScreenModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ElevatorButtonClientScreenModule
implements IClientScreenModule<ElevatorButtonScreenModule.ModuleElevatorInfo> {
    public static final int LARGESIZE = 22;
    public static final int SMALLSIZE = 16;
    private int buttonColor = 0xFFFFFF;
    private int currentLevelButtonColor = 0xFFFF00;
    private boolean vertical = false;
    private boolean large = false;
    private boolean lights = false;
    private boolean start1 = false;
    private String[] levels = new String[8];

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        if (this.vertical) {
            return this.large ? 110 : 112;
        }
        return this.large ? 22 : 16;
    }

    private int getDimension() {
        return this.large ? 22 : 16;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, ElevatorButtonScreenModule.ModuleElevatorInfo screenData, ModuleRenderInfo renderInfo) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)false);
        if (screenData == null) {
            return;
        }
        int currentLevel = screenData.getLevel();
        int buttons = screenData.getMaxLevel();
        BlockPos pos = screenData.getPos();
        List<Integer> heights = screenData.getHeights();
        if (this.vertical) {
            this.renderButtonsVertical(renderHelper, currenty, currentLevel, buttons, pos, heights, renderInfo);
        } else {
            this.renderButtonsHorizontal(renderHelper, currenty, currentLevel, buttons, pos, heights, renderInfo);
        }
    }

    private void renderButtonsHorizontal(IModuleRenderHelper renderHelper, int currenty, int currentLevel, int buttons, BlockPos pos, List<Integer> heights, ModuleRenderInfo renderInfo) {
        int max;
        int xoffset = 5;
        int n = max = this.large ? 6 : 9;
        if (buttons > max) {
            buttons = max;
        }
        for (int i = 0; i < buttons; ++i) {
            boolean hasText;
            String text = this.getLevelText(i, pos, heights);
            boolean bl = hasText = text != null;
            if (text == null) {
                text = String.valueOf(i + (this.start1 ? 1 : 0));
            }
            int col = i == currentLevel ? this.currentLevelButtonColor : this.buttonColor;
            int textoffset = this.large ? 3 : 0;
            int x = xoffset + 3 + textoffset;
            int y = currenty + 2 + textoffset;
            if (this.lights) {
                RenderHelper.drawBeveledBox((int)xoffset, (int)currenty, (int)(xoffset + this.getDimension() - 4), (int)(currenty + this.getDimension() - 2), (int)-1, (int)-1, (int)(-16777216 + col));
                if (hasText) {
                    renderHelper.renderTextTrimmed(x, y, 0xFFFFFF, renderInfo, text, 480);
                }
            } else {
                RenderHelper.drawBeveledBox((int)xoffset, (int)currenty, (int)(xoffset + this.getDimension() - 4), (int)(currenty + this.getDimension() - 2), (int)-1118482, (int)-13421773, (int)-10066330);
                renderHelper.renderTextTrimmed(x, y, col, renderInfo, text, (this.getDimension() - 4) * 4);
            }
            xoffset += this.getDimension() - 2;
        }
    }

    private void renderButtonsVertical(IModuleRenderHelper renderHelper, int currenty, int currentLevel, int buttons, BlockPos pos, List<Integer> heights, ModuleRenderInfo renderInfo) {
        int max = this.large ? 6 : 8;
        int w = buttons > max ? 58 : 120;
        int y = currenty;
        boolean twocols = buttons > max;
        for (int i = 0; i < buttons; ++i) {
            boolean hasText;
            int level = buttons - i - 1;
            int xoffset = twocols ? (level >= max ? 70 : 5) : 5;
            String text = this.getLevelText(level, pos, heights);
            boolean bl = hasText = text != null;
            if (text == null) {
                text = String.valueOf(level + (this.start1 ? 1 : 0));
            }
            int col = level == currentLevel ? this.currentLevelButtonColor : this.buttonColor;
            int textoffset = this.large ? 3 : 0;
            int x = xoffset + 3 + textoffset;
            int yy = y + 2 + textoffset;
            if (this.lights) {
                RenderHelper.drawBeveledBox((int)xoffset, (int)y, (int)(xoffset + w), (int)(y + this.getDimension() - 2), (int)-1, (int)-1, (int)(-16777216 + col));
                if (hasText) {
                    renderHelper.renderTextTrimmed(x, yy, 0xFFFFFF, renderInfo, text, w * 4);
                }
            } else {
                RenderHelper.drawBeveledBox((int)xoffset, (int)y, (int)(xoffset + w), (int)(y + this.getDimension() - 2), (int)-1118482, (int)-13421773, (int)-10066330);
                renderHelper.renderTextTrimmed(x, yy, col, renderInfo, text, w * 4);
            }
            y += this.getDimension() - 2;
            if (level != max) continue;
            y = currenty;
        }
    }

    private String getLevelText(int level, BlockPos pos, List<Integer> heights) {
        if (this.hasLevelText(level)) {
            return this.levels[level];
        }
        if (level < heights.size()) {
            BlockPos posY = ElevatorTileEntity.getPosAtY(pos, heights.get(level));
            TileEntity te = MinecraftTools.getWorld((Minecraft)Minecraft.func_71410_x()).func_175625_s(posY);
            if (te instanceof ElevatorTileEntity) {
                return ((ElevatorTileEntity)te).getName();
            }
        }
        return null;
    }

    private boolean hasLevelText(int i) {
        return i < this.levels.length && this.levels[i] != null && !this.levels[i].isEmpty();
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.color("buttonColor", "Button color").color("curColor", "Current level button color").nl().toggle("vertical", "Vertical", "Order the buttons vertically").toggle("large", "Large", "Larger buttons").nl().toggle("lights", "Lights", "Use buttons resembling lights").toggle("start1", "Start 1", "start numbering at 1 instead of 0").nl().text("l0", "Level 0 name").text("l1", "Level 1 name").text("l2", "Level 2 name").text("l3", "Level 3 name").nl().text("l4", "Level 4 name").text("l5", "Level 5 name").text("l6", "Level 6 name").text("l7", "Level 7 name").nl().label("Block:").block("elevator").nl();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.buttonColor = tagCompound.func_74764_b("buttonColor") ? tagCompound.func_74762_e("buttonColor") : 0xFFFFFF;
            this.currentLevelButtonColor = tagCompound.func_74764_b("curColor") ? tagCompound.func_74762_e("curColor") : 0xFFFF00;
            this.vertical = tagCompound.func_74767_n("vertical");
            this.large = tagCompound.func_74767_n("large");
            this.lights = tagCompound.func_74767_n("lights");
            this.start1 = tagCompound.func_74767_n("start1");
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = tagCompound.func_74764_b("l" + i) ? tagCompound.func_74779_i("l" + i) : null;
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

