/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.blocks.powercell.PowerCellBlock;
import mcjty.rftools.blocks.powercell.PowerCellInfoPacketClient;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PowerCellInfoPacketServer
implements InfoPacketServer {
    private int id;
    private BlockPos pos;

    public PowerCellInfoPacketServer() {
    }

    public PowerCellInfoPacketServer(PowerCellTileEntity tileEntity) {
        this.id = tileEntity.getNetworkId();
        this.pos = tileEntity.func_174877_v();
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        World world = player.func_130014_f_();
        TileEntity te = world.func_175625_s(this.pos);
        if (this.id == -1) {
            if (te instanceof PowerCellTileEntity) {
                PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
                return Optional.of(new PowerCellInfoPacketClient(powerCellTileEntity.getEnergy(), 1, PowerCellBlock.isSimple(world.func_180495_p(this.pos).func_177230_c()) ? 1 : 0, PowerCellBlock.isAdvanced(world.func_180495_p(this.pos).func_177230_c()) ? 1 : 0, powerCellTileEntity.getTotalInserted(), powerCellTileEntity.getTotalExtracted(), powerCellTileEntity.getRfPerTickPerSide(), 1.0f));
            }
            return Optional.empty();
        }
        PowerCellNetwork generatorNetwork = PowerCellNetwork.getChannels(world);
        PowerCellNetwork.Network network = generatorNetwork.getChannel(this.id);
        int totInserted = 0;
        int totExtracted = 0;
        int rfPerTick = 0;
        float costFactor = 0.0f;
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            totInserted = powerCellTileEntity.getTotalInserted();
            totExtracted = powerCellTileEntity.getTotalExtracted();
            rfPerTick = powerCellTileEntity.getRfPerTickPerSide();
            costFactor = powerCellTileEntity.getCostFactor();
        }
        return Optional.of(new PowerCellInfoPacketClient(network.getEnergy(), network.getBlockCount(), network.getSimpleBlockCount(), network.getAdvancedBlockCount(), totInserted, totExtracted, rfPerTick, costFactor));
    }
}

