/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.threelogic;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.generic.LogicFacing;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import mcjty.rftools.blocks.logic.threelogic.GuiThreeLogic;
import mcjty.rftools.blocks.logic.threelogic.ThreeLogicTileEntity;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ThreeLogicBlock
extends LogicSlabBlock<ThreeLogicTileEntity, EmptyContainer> {
    public ThreeLogicBlock() {
        super(Material.field_151573_f, "logic_block", ThreeLogicTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiThreeLogic.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block can do various logical");
            list.add(TextFormatting.WHITE + "operations on three inputs.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    protected void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof LogicSlabBlock && te instanceof LogicTileEntity) {
            LogicTileEntity logicTileEntity = (LogicTileEntity)te;
            LogicFacing facing = logicTileEntity.getFacing(state);
            EnumFacing downSide = facing.getSide();
            EnumFacing inputSide = facing.getInputSide();
            EnumFacing leftSide = ThreeLogicBlock.rotateLeft(downSide, inputSide);
            EnumFacing rightSide = ThreeLogicBlock.rotateRight(downSide, inputSide);
            int powered1 = this.getInputStrength(world, pos, leftSide) > 0 ? 1 : 0;
            int powered2 = this.getInputStrength(world, pos, inputSide) > 0 ? 2 : 0;
            int powered3 = this.getInputStrength(world, pos, rightSide) > 0 ? 4 : 0;
            logicTileEntity.setPowerInput(powered1 + powered2 + powered3);
        }
    }

    public static EnumFacing rotateLeft(EnumFacing downSide, EnumFacing inputSide) {
        switch (downSide) {
            case DOWN: {
                return inputSide.func_176746_e();
            }
            case UP: {
                return inputSide.func_176735_f();
            }
            case NORTH: {
                return inputSide.func_176732_a(EnumFacing.Axis.Z);
            }
            case SOUTH: {
                return inputSide.func_176734_d().func_176732_a(EnumFacing.Axis.Z);
            }
            case WEST: {
                return inputSide.func_176732_a(EnumFacing.Axis.X);
            }
            case EAST: {
                return inputSide.func_176734_d().func_176732_a(EnumFacing.Axis.X);
            }
        }
        return inputSide;
    }

    public static EnumFacing rotateRight(EnumFacing downSide, EnumFacing inputSide) {
        return ThreeLogicBlock.rotateLeft(downSide.func_176734_d(), inputSide);
    }

    public int getGuiID() {
        return RFTools.GUI_THREE_LOGIC;
    }
}

