/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import mcjty.lib.tools.MinecraftTools;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;

public class ElevatorTESR
extends TileEntitySpecialRenderer<ElevatorTileEntity> {
    private static final BlockRenderLayer[] LAYERS = BlockRenderLayer.values();

    public void renderTileEntityAt(ElevatorTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te.isMoving()) {
            AxisAlignedBB aabb = te.getAABBAboveElevator(0.0);
            boolean on = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).func_174813_aQ().func_72326_a(aabb);
            double diff = on ? (double)te.func_174877_v().func_177956_o() - (y + te.getMovingY()) - 1.0 : 0.0;
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            this.func_147499_a(TextureMap.field_110575_b);
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            IBlockState movingState = te.getMovingState();
            GlStateManager.func_179137_b((double)0.0, (double)(te.getMovingY() - (double)te.func_174877_v().func_177956_o() + diff), (double)0.0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            for (BlockRenderLayer layer : LAYERS) {
                if (!movingState.func_177230_c().canRenderInLayer(movingState, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                for (BlockPos pos : te.getPositions()) {
                    tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    int dx = te.func_174877_v().func_177958_n() - pos.func_177958_n();
                    int dy = te.func_174877_v().func_177956_o() - pos.func_177956_o();
                    int dz = te.func_174877_v().func_177952_p() - pos.func_177952_p();
                    tessellator.func_178180_c().func_178969_c(x - (double)pos.func_177958_n() - (double)dx, y - (double)pos.func_177956_o() - (double)dy, z - (double)pos.func_177952_p() - (double)dz);
                    ElevatorTESR.renderBlock(dispatcher, movingState, pos, (IBlockAccess)te.func_145831_w(), tessellator.func_178180_c());
                    tessellator.func_78381_a();
                }
            }
            tessellator.func_178180_c().func_178969_c(0.0, 0.0, 0.0);
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }
    }

    public boolean isGlobalRenderer(ElevatorTileEntity te) {
        return te.isMoving();
    }

    private static boolean renderBlock(BlockRendererDispatcher dispatcher, IBlockState state, BlockPos pos, IBlockAccess blockAccess, VertexBuffer worldRendererIn) {
        try {
            EnumBlockRenderType enumblockrendertype = state.func_185901_i();
            if (enumblockrendertype == EnumBlockRenderType.INVISIBLE) {
                return false;
            }
            if (blockAccess.func_175624_G() != WorldType.field_180272_g) {
                try {
                    state = state.func_185899_b(blockAccess, pos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (enumblockrendertype) {
                case MODEL: {
                    IBakedModel model = dispatcher.func_184389_a(state);
                    state = state.func_177230_c().getExtendedState(state, blockAccess, pos);
                    return dispatcher.func_175019_b().func_178267_a(blockAccess, model, state, pos, worldRendererIn, false);
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_180523_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.func_177230_c(), (int)state.func_177230_c().func_176201_c(state));
            throw new ReportedException(crashreport);
        }
    }
}

