/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.GuiButtonHideable;
import com.enderio.core.client.gui.widget.GuiToolTip;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;

public class TooltipButton
extends GuiButtonHideable {
    protected int xOrigin;
    protected int yOrigin;
    protected IGuiScreen gui;
    protected String[] toolTipText;
    protected GuiToolTip toolTip;

    public TooltipButton(IGuiScreen gui, int id, int x, int y, int widthIn, int heightIn, String buttonText) {
        super(id, x, y, widthIn, heightIn, buttonText);
        this.gui = gui;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public void setToolTip(String ... tooltipText) {
        if (this.toolTip == null) {
            this.toolTip = new GuiToolTip(this.getBounds(), tooltipText);
        } else {
            this.toolTip.setToolTipText(tooltipText);
        }
        this.toolTipText = tooltipText;
        this.updateTooltipBounds();
    }

    protected void setToolTip(GuiToolTip newToolTip) {
        boolean addTooltip = false;
        if (this.toolTip != null) {
            addTooltip = this.gui.removeToolTip(this.toolTip);
        }
        this.toolTip = newToolTip;
        if (addTooltip && this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.updateTooltipBounds();
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.xOrigin, this.yOrigin, this.getWidth(), this.getHeight());
    }

    public void onGuiInit() {
        this.gui.addButton(this);
        if (this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.field_146128_h = this.xOrigin + this.gui.getGuiLeft();
        this.field_146129_i = this.yOrigin + this.gui.getGuiTop();
    }

    public void detach() {
        this.gui.removeToolTip(this.toolTip);
        this.gui.removeButton(this);
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    public GuiToolTip getToolTip() {
        return this.toolTip;
    }

    public void setSize(int width, int height) {
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.updateTooltipBounds();
    }

    public TooltipButton setPosition(int x, int y) {
        this.xOrigin = x;
        this.yOrigin = y;
        this.updateTooltipBounds();
        return this;
    }

    public void setXOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public void setYOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    private void updateTooltipBounds() {
        if (this.toolTip != null) {
            this.toolTip.setBounds(new Rectangle(this.xOrigin, this.yOrigin, this.field_146120_f, this.field_146121_g));
        }
    }

    protected void updateTooltip(Minecraft mc, int mouseX, int mouseY) {
        if (this.toolTip != null) {
            this.toolTip.setIsVisible(this.field_146125_m && this.field_146124_l);
        }
    }

    protected final void doDrawButton(Minecraft mc, int mouseX, int mouseY) {
        super.func_146112_a(mc, mouseX, mouseY);
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        this.updateTooltip(mc, mouseX, mouseY);
        this.doDrawButton(mc, mouseX, mouseY);
    }
}

