/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.exciter;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.UUID;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.helpers.BlockHelpers;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileRFExciter
extends TileEntity
implements IEnergyProvider,
ITickable {
    public UUID owner;
    public int lastEnergyUsed;
    public EnumFacing targetDirection = null;
    public int maxOut = ConfigMan.rfExciter1_output;
    public int upgradeCount;
    public float wirelessEfficiency = 1.0f;

    public String getOwner() {
        return this.owner == null ? null : this.owner.toString();
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return RedfluxField.requestEnergy(maxExtract, simulate, this.getOwner());
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("upgradeCount", this.upgradeCount);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        try {
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
            this.upgradeCount = tag.func_74762_e("upgradeCount");
        }
        catch (Exception ex) {
            Logger.error("HEY YOU! An RF Exciter has corrupt data at %s The owner will need to replace it.", this.func_174877_v());
        }
    }

    public void func_73660_a() {
        BlockPos targetBlock;
        TileEntity tile;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.owner == null) {
            return;
        }
        if (this.targetDirection == null) {
            this.targetDirection = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockHelpers.FACING);
        }
        if ((tile = this.field_145850_b.func_175625_s(targetBlock = this.func_174877_v().func_177971_a(this.targetDirection.func_176730_m()))) instanceof IEnergyReceiver) {
            int netPower = this.getNetPower();
            int tosend = this.extractEnergy(null, netPower, true);
            int needed = ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.func_176734_d(), tosend, true);
            int willSend = Math.round((float)needed * this.wirelessEfficiency);
            ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.func_176734_d(), willSend, false);
            if (needed > 0) {
                this.func_70296_d();
            }
            this.lastEnergyUsed = needed;
            this.extractEnergy(null, needed, false);
        }
    }

    public int getNetPower() {
        int power = this.maxOut + this.upgradeCount * 100;
        return power;
    }
}

