/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.item.map;

import codechicken.lib.render.item.map.IMapRenderer;
import java.util.IdentityHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MapRenderRegistry {
    private static IdentityHashMap<Item, IMapRenderer> mapRenderers = new IdentityHashMap();

    public static boolean shouldHandle(ItemStack stack, boolean inFrame) {
        IMapRenderer mapRenderer = mapRenderers.get(stack.func_77973_b());
        if (mapRenderer != null) {
            MapData data = Items.field_151098_aY.func_77873_a(stack, (World)Minecraft.func_71410_x().field_71441_e);
            return mapRenderer.shouldHandle(stack, data, inFrame);
        }
        return false;
    }

    public static void handleRender(ItemStack stack, boolean inFrame) {
        IMapRenderer mapRenderer = mapRenderers.get(stack.func_77973_b());
        if (mapRenderer != null) {
            MapData data = Items.field_151098_aY.func_77873_a(stack, (World)Minecraft.func_71410_x().field_71441_e);
            mapRenderer.renderMap(stack, data, inFrame);
        }
    }

    public static void registerMapRenderer(Item item, IMapRenderer mapRenderer) {
        mapRenderers.put(item, mapRenderer);
    }

    @SubscribeEvent
    public void onItemFrameRender(RenderItemInFrameEvent event) {
        if (MapRenderRegistry.shouldHandle(event.getItem(), true)) {
            event.setCanceled(true);
            MapRenderRegistry.handleRender(event.getItem(), true);
        }
    }
}

