/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class CCRSConsumer
implements IVertexConsumer {
    private final CCRenderState ccrs;
    private Vector3 offset = Vector3.zero;

    public CCRSConsumer(CCRenderState ccrs) {
        this.ccrs = ccrs;
    }

    public VertexFormat getVertexFormat() {
        return this.ccrs.getVertexFormat();
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.ccrs.sprite = texture;
    }

    public void put(int e, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement fmte = format.func_177348_c(e);
        switch (fmte.func_177375_c()) {
            case POSITION: {
                this.ccrs.vert.vec.set(data).add(this.offset);
                break;
            }
            case UV: {
                if (fmte.func_177369_e() == 0) {
                    this.ccrs.vert.uv.set(data[0], data[1]);
                    break;
                }
                this.ccrs.brightness = (int)(data[1] * 65535.0f / 32.0f) << 20 | (int)(data[0] * 65535.0f / 32.0f) << 4;
                break;
            }
            case COLOR: {
                this.ccrs.colour = Colour.packRGBA(data);
                break;
            }
            case NORMAL: {
                this.ccrs.normal.set(data);
                break;
            }
            case PADDING: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Generic vertex format element");
            }
        }
        if (e == format.func_177345_h() - 1) {
            this.ccrs.writeVert();
        }
    }

    public void setOffset(Vector3 offset) {
        this.offset = offset;
    }

    public void setOffset(BlockPos offset) {
        this.offset = Vector3.fromBlockPos(offset);
    }

    public void setQuadTint(int tint) {
    }

    public void setQuadOrientation(EnumFacing orientation) {
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
    }
}

