/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.util.VertexDataUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class PlanarFaceBakery {
    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite) {
        return PlanarFaceBakery.bakeFace(face, sprite, DefaultVertexFormats.field_176599_b);
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format) {
        return PlanarFaceBakery.bakeFace(face, sprite, format, -1);
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format, int colour) {
        return PlanarFaceBakery.bakeFace(face, sprite, format, new ColourRGBA(colour));
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format, Colour colour) {
        IconTransformation t = new IconTransformation(sprite);
        double x1 = Cuboid6.full.min.x;
        double x2 = Cuboid6.full.max.x;
        double y1 = Cuboid6.full.min.y;
        double y2 = Cuboid6.full.max.y;
        double z1 = Cuboid6.full.min.z;
        double z2 = Cuboid6.full.max.z;
        switch (face) {
            case DOWN: {
                double u1 = x1;
                double v1 = z1;
                double u2 = x2;
                double v2 = z2;
                Vertex5 vert1 = new Vertex5(x1, y1, z2, u1, v2);
                Vertex5 vert2 = new Vertex5(x1, y1, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y1, z1, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z2, u2, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case UP: {
                double u1 = x1;
                double v1 = z1;
                double u2 = x2;
                double v2 = z2;
                Vertex5 vert1 = new Vertex5(x2, y2, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z1, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y2, z2, u1, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case NORTH: {
                double u1 = 1.0 - x1;
                double v1 = 1.0 - y2;
                double u2 = 1.0 - x2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x1, y1, z1, u1, v2);
                Vertex5 vert2 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y2, z1, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z1, u2, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case SOUTH: {
                double u1 = x1;
                double v1 = 1.0 - y2;
                double u2 = x2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x2, y1, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z2, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z2, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y1, z2, u1, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case WEST: {
                double u1 = z1;
                double v1 = 1.0 - y2;
                double u2 = z2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x1, y1, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x1, y2, z2, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y1, z1, u1, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case EAST: {
                double u1 = 1.0 - z1;
                double v1 = 1.0 - y2;
                double u2 = 1.0 - z2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x2, y1, z1, u1, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y2, z2, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z2, u2, v2);
                return PlanarFaceBakery.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
        }
        return new BakedQuad(null, 1, null, null, true, null);
    }

    private static BakedQuad buildQuad(VertexFormat format, TextureAtlasSprite sprite, EnumFacing face, Colour colour, UVTransformation t, Vertex5 v1, Vertex5 v2, Vertex5 v3, Vertex5 v4) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(-1);
        builder.setQuadOrientation(face);
        builder.setTexture(sprite);
        t.apply(v1.uv);
        t.apply(v2.uv);
        t.apply(v3.uv);
        t.apply(v4.uv);
        PlanarFaceBakery.putVertex(builder, format, face, v1, colour);
        PlanarFaceBakery.putVertex(builder, format, face, v2, colour);
        PlanarFaceBakery.putVertex(builder, format, face, v3, colour);
        PlanarFaceBakery.putVertex(builder, format, face, v4, colour);
        return VertexDataUtils.copyQuad(builder.build());
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, EnumFacing face, Vertex5 vert, Colour colour) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            VertexFormatElement element = format.func_177348_c(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    Vector3 vec = vert.vec;
                    builder.put(e, new float[]{(float)vec.x, (float)vec.y, (float)vec.z, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)(colour.r & 0xFF) / 255.0f, (float)(colour.g & 0xFF) / 255.0f, (float)(colour.b & 0xFF) / 255.0f, (float)(colour.a & 0xFF) / 255.0f});
                    continue block6;
                }
                case UV: {
                    UV uv = vert.uv;
                    builder.put(e, new float[]{(float)uv.u, (float)uv.v, 0.0f, 1.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static List<BakedQuad> shadeQuadFaces(BakedQuad ... quads) {
        return PlanarFaceBakery.shadeQuadFaces(Arrays.asList(quads));
    }

    public static List<BakedQuad> shadeQuadFaces(List<BakedQuad> quads) {
        LinkedList<BakedQuad> shadedQuads = new LinkedList<BakedQuad>();
        for (BakedQuad quad : quads) {
            int[] rawData = quad.func_178209_a();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < quad.getFormat().func_177345_h(); ++e) {
                    VertexFormatElement element = quad.getFormat().func_177348_c(e);
                    if (element.func_177375_c() != VertexFormatElement.EnumUsage.COLOR) continue;
                    float[] data = new float[4];
                    LightUtil.unpack((int[])rawData, (float[])data, (VertexFormat)quad.getFormat(), (int)v, (int)e);
                    data = PlanarFaceBakery.diffuseFaceLight(quad.func_178210_d(), data);
                    LightUtil.pack((float[])data, (int[])rawData, (VertexFormat)quad.getFormat(), (int)v, (int)e);
                }
            }
            shadedQuads.add(new BakedQuad(rawData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
        }
        return shadedQuads;
    }

    private static float[] diffuseFaceLight(EnumFacing face, float[] colour) {
        double diffuse;
        switch (face) {
            case DOWN: {
                diffuse = 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                diffuse = 0.8;
                break;
            }
            case WEST: 
            case EAST: {
                diffuse = 0.6;
                break;
            }
            default: {
                diffuse = 1.0;
            }
        }
        colour[0] = (float)((double)colour[0] * diffuse);
        colour[1] = (float)((double)colour[1] * diffuse);
        colour[2] = (float)((double)colour[2] * diffuse);
        return colour;
    }
}

