/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import codechicken.lib.model.BakedModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareMultiModel;
import codechicken.lib.texture.TextureUtils;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;

public class CCMultiModel
implements IModel {
    private final IModel base;
    private final BakedModelProperties baseProperties;
    private final List<IModel> subModels;

    public CCMultiModel(IModel base, BakedModelProperties baseProperties, List<IModel> subModels) {
        this.base = base;
        this.baseProperties = baseProperties;
        this.subModels = subModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> deps = new ArrayList<ResourceLocation>();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (IModel subModel : this.subModels) {
            deps.addAll(subModel.getDependencies());
        }
        return deps;
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> deps = new ArrayList<ResourceLocation>();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (IModel subModel : this.subModels) {
            deps.addAll(subModel.getTextures());
        }
        return deps;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseBakedModel = null;
        if (this.base != null) {
            baseBakedModel = this.base.bake(state, format, bakedTextureGetter);
        }
        ArrayList<IBakedModel> subBakedModels = new ArrayList<IBakedModel>();
        TextureAtlasSprite particle = null;
        if (baseBakedModel != null) {
            particle = baseBakedModel.func_177554_e();
        }
        for (IModel subModel : this.subModels) {
            TextureAtlasSprite particleCandidate = null;
            IBakedModel bakedSubModel = subModel.bake(subModel.getDefaultState(), format, bakedTextureGetter);
            subBakedModels.add(bakedSubModel);
            if (particle != null && particle != TextureUtils.getMissingSprite()) continue;
            if (particleCandidate == null || particleCandidate == TextureUtils.getMissingSprite()) {
                particleCandidate = bakedSubModel.func_177554_e();
            }
            if (particleCandidate == null && particleCandidate == TextureUtils.getMissingSprite()) continue;
            particle = particleCandidate;
        }
        if (particle == null) {
            particle = TextureUtils.getMissingSprite();
        }
        return new PerspectiveAwareMultiModel(baseBakedModel, subBakedModels, state, new BakedModelProperties(this.baseProperties, particle));
    }

    public IModelState getDefaultState() {
        return this.base.getDefaultState();
    }
}

