/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm.discovery;

import codechicken.lib.asm.CCLCorePlugin;
import codechicken.lib.asm.discovery.IStringMatcher;
import codechicken.lib.util.CommonUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import org.objectweb.asm.ClassReader;

public class ClassDiscoverer {
    public IStringMatcher matcher;
    public String[] superclasses;
    public ArrayList<Class<?>> classes;
    public ModClassLoader modClassLoader;

    public ClassDiscoverer(IStringMatcher matcher, Class<?> ... superclasses) {
        this.matcher = matcher;
        this.superclasses = new String[superclasses.length];
        for (int i = 0; i < superclasses.length; ++i) {
            this.superclasses[i] = superclasses[i].getName().replace('.', '/');
        }
        this.classes = new ArrayList();
        this.modClassLoader = Loader.instance().getModClassLoader();
    }

    public ClassDiscoverer(Class<?> ... superclasses) {
        this(new IStringMatcher(){

            @Override
            public boolean matches(String test) {
                return true;
            }
        }, superclasses);
    }

    public ArrayList<Class<?>> findClasses() {
        try {
            this.findClasspathMods();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.classes;
    }

    private void checkAddClass(String resource) {
        try {
            String classname = resource.replace(".class", "").replace("\\", ".").replace("/", ".");
            byte[] bytes = Launch.classLoader.getClassBytes(classname);
            if (bytes == null) {
                return;
            }
            ClassReader reader = new ClassReader(bytes);
            ArrayList interfaces = Lists.newArrayList((Object[])new String[]{reader.getSuperName()});
            for (String itf : reader.getInterfaces()) {
                interfaces.add(itf);
            }
            for (String superclass : this.superclasses) {
                if (interfaces.contains(superclass)) continue;
                return;
            }
            this.addClass(classname);
        }
        catch (IOException e) {
            CCLCorePlugin.logger.error("Unable to load class: " + resource, (Throwable)e);
        }
    }

    private void addClass(String classname) {
        try {
            Class<?> class1 = Class.forName(classname, true, (ClassLoader)this.modClassLoader);
            this.classes.add(class1);
        }
        catch (Throwable t) {
            CCLCorePlugin.logger.error("Unable to load class: " + classname, t);
        }
    }

    private void findClasspathMods() {
        List mods = Loader.instance().getActiveModList();
        HashSet<String> searched = new HashSet<String>();
        for (ModContainer mod : mods) {
            File source = mod.getSource();
            if (source == null || searched.contains(source.getAbsolutePath())) continue;
            searched.add(source.getAbsolutePath());
            if (source.isFile()) {
                CCLCorePlugin.logger.debug("Found a mod container %s, examining for codechicken classes", new Object[]{source.getAbsolutePath()});
                try {
                    this.readFromZipFile(source);
                }
                catch (Exception e) {
                    CCLCorePlugin.logger.error("Failed to scan " + source.getAbsolutePath() + ", the zip file is invalid", (Throwable)e);
                }
                continue;
            }
            if (!source.isDirectory()) continue;
            CCLCorePlugin.logger.debug("Found a minecraft related directory at %s, examining for codechicken classes", new Object[]{source.getAbsolutePath()});
            this.readFromDirectory(source, source);
        }
    }

    private void readFromZipFile(File file) throws IOException {
        ZipEntry zipentry;
        FileInputStream fileinputstream = new FileInputStream(file);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        while ((zipentry = zipinputstream.getNextEntry()) != null) {
            String name;
            String fullname = zipentry.getName().replace('\\', '/');
            int pos = fullname.lastIndexOf(47);
            String string = name = pos == -1 ? fullname : fullname.substring(pos + 1);
            if (zipentry.isDirectory() || !this.matcher.matches(name)) continue;
            this.checkAddClass(fullname);
        }
        fileinputstream.close();
    }

    private void readFromDirectory(File directory, File basedirectory) {
        for (File child : directory.listFiles()) {
            if (child.isDirectory()) {
                this.readFromDirectory(child, basedirectory);
                continue;
            }
            if (!child.isFile() || !this.matcher.matches(child.getName())) continue;
            String fullname = CommonUtils.getRelativePath(basedirectory, child);
            this.checkAddClass(fullname);
        }
    }
}

