/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm;

import codechicken.lib.asm.ASMHelper;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.lib.asm", "codechicken.lib.config", "codechicken.lib.fingerprint"})
public class CCLCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static Logger logger = LogManager.getLogger((String)"CodeChicken Lib");

    public String[] getASMTransformerClass() {
        return new String[]{"codechicken.lib.asm.ClassHeirachyManager", "codechicken.lib.asm.CCL_ASMTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public Void call() throws Exception {
        this.scanMods();
        new ASMHelper();
        return null;
    }

    private void scanMods() {
        File[] files;
        File modsDir = new File((File)FMLInjectionData.data()[6], "mods");
        for (File file : modsDir.listFiles()) {
            this.scanMod(file);
        }
        File versionModsDir = new File(modsDir, (String)FMLInjectionData.data()[4]);
        if (versionModsDir.exists() && (files = versionModsDir.listFiles()) != null) {
            for (File file : files) {
                this.scanMod(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanMod(File file) {
        if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) {
            return;
        }
        try {
            JarFile jar = new JarFile(file);
            try {
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    return;
                }
                Attributes attr = manifest.getMainAttributes();
                if (attr == null) {
                    return;
                }
                String transformer = attr.getValue("CCTransformerExclusions");
                if (transformer != null) {
                    List<String> exclusions = Arrays.asList(transformer.split(","));
                    for (String ex : exclusions) {
                        Launch.classLoader.addTransformerExclusion(ex);
                    }
                }
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            logger.error("CodeChickenLib: Failed to read jar file: " + file.getName(), (Throwable)e);
        }
    }
}

