/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.NotificationId;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.client.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.lib.Notification;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageNotifyPlayer
extends MessageToClient<MessageNotifyPlayer> {
    private static final int FLAG_HAS_TEXT = 1;
    private static final int FLAG_HAS_ITEM = 2;
    private NotificationId ID;

    public MessageNotifyPlayer() {
    }

    public MessageNotifyPlayer(NotificationId id) {
        this.ID = id;
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.ID = MessageNotifyPlayer.readID(io);
    }

    public void toBytes(ByteBuf io) {
        MessageNotifyPlayer.writeID(io, this.ID);
    }

    @Override
    public void onMessage(MessageNotifyPlayer m, EntityPlayer player) {
        EnumNotificationDisplay display = (EnumNotificationDisplay)((Object)FTBLibClientConfig.NOTIFICATIONS.getNonnull());
        if (display == EnumNotificationDisplay.OFF) {
            return;
        }
        INotification n = (INotification)SharedClientData.INSTANCE.notifications.get(m.ID);
        if (n != null) {
            FTBLibMod.PROXY.displayNotification(display, n);
        }
    }

    private static void writeID(ByteBuf io, NotificationId id) {
        LMNetUtils.writeResourceLocation(io, id.getID());
        io.writeByte(id.getVariant());
    }

    private static NotificationId readID(ByteBuf io) {
        ResourceLocation id = LMNetUtils.readResourceLocation(io);
        return new NotificationId(id, io.readByte());
    }

    static void write(ByteBuf io, INotification n) {
        ItemStack item;
        MessageNotifyPlayer.writeID(io, n.getId());
        io.writeInt(n.getColor());
        io.writeShort(n.getTimer());
        int flags = 0;
        List<ITextComponent> text = n.getText();
        if (!text.isEmpty()) {
            flags |= 1;
        }
        if ((item = n.getItem()) != null) {
            flags |= 2;
        }
        io.writeByte(flags);
        if (!text.isEmpty()) {
            io.writeByte(text.size());
            for (ITextComponent t : text) {
                LMNetUtils.writeTextComponent(io, t);
            }
        }
        if (item != null) {
            ByteBufUtils.writeItemStack((ByteBuf)io, (ItemStack)item);
        }
    }

    static Notification read(ByteBuf io) {
        Notification n = new Notification(MessageNotifyPlayer.readID(io));
        n.setColor(io.readInt());
        n.setTimer(io.readUnsignedShort());
        short flags = io.readUnsignedByte();
        if (Bits.getFlag(flags, 1)) {
            int s = io.readUnsignedByte();
            while (--s >= 0) {
                n.addText(LMNetUtils.readTextComponent(io));
            }
        }
        if (Bits.getFlag(flags, 2)) {
            n.setItem(ByteBufUtils.readItemStack((ByteBuf)io));
        }
        return n;
    }
}

