/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.io;

import com.feed_the_beast.ftbl.lib.io.ByteIOStream;

public enum ByteCount {
    BYTE(1),
    SHORT(2),
    INT(4);

    public final int bytes;

    private ByteCount(int i) {
        this.bytes = i;
    }

    public void write(ByteIOStream io, int num) {
        switch (this) {
            case BYTE: {
                io.writeByte(num);
                return;
            }
            case SHORT: {
                io.writeShort(num);
                return;
            }
        }
        io.writeInt(num);
    }

    public int read(ByteIOStream io) {
        switch (this) {
            case BYTE: {
                byte b = io.readByte();
                if (b == -1) {
                    return -1;
                }
                return b & 0xFF;
            }
            case SHORT: {
                short s = io.readShort();
                if (s == -1) {
                    return -1;
                }
                return s & 0xFFFF;
            }
        }
        return io.readInt();
    }
}

