/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemPageIconRenderer
implements IPageIconRenderer {
    private List<ItemStack> items;

    public ItemPageIconRenderer(ItemStack is) {
        this.items = Collections.singletonList(is);
    }

    public ItemPageIconRenderer(Item item) {
        this.items = new ArrayList<ItemStack>();
        item.func_150895_a(item, CreativeTabs.field_78027_g, this.items);
    }

    public ItemPageIconRenderer(JsonElement json) {
        try {
            if (json.isJsonArray()) {
                this.items = new ArrayList<ItemStack>(json.getAsJsonArray().size());
                for (JsonElement e : json.getAsJsonArray()) {
                    this.items.add(ItemStackSerializer.parseItem(e.getAsString()));
                }
            } else {
                this.items = Collections.singletonList(ItemStackSerializer.parseItem(json.getAsString()));
            }
        }
        catch (Exception ex) {
            ItemStack item = new ItemStack(Blocks.field_180401_cv);
            item.func_151001_c("Broken Item!");
            this.items = Collections.singletonList(item);
        }
    }

    @Override
    public void renderIcon(IGui gui, IWidget widget, int x, int y) {
        GuiHelper.drawItem(Minecraft.func_71410_x().func_175599_af(), this.items.get((int)(System.currentTimeMillis() / 1000L % (long)this.items.size())), x, y, true);
    }
}

