/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IPanel;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.gui.PanelLM;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoPageHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public class InfoListLine
extends EmptyInfoPageLine {
    private final List<IInfoTextLine> textLines;
    private final boolean ordered;

    public InfoListLine(InfoPage p, JsonElement json) {
        this.textLines = new ArrayList<IInfoTextLine>();
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("list")) {
                for (JsonElement element : o.get("list").getAsJsonArray()) {
                    IInfoTextLine line = InfoPageHelper.createLine(p, element);
                    if (line == null) continue;
                    this.textLines.add(line);
                }
            }
            this.ordered = o.has("ordered") && o.get("ordered").getAsBoolean();
        } else {
            for (JsonElement element : json.getAsJsonArray()) {
                IInfoTextLine line = InfoPageHelper.createLine(p, element);
                if (line == null) continue;
                this.textLines.add(line);
            }
            this.ordered = false;
        }
    }

    public InfoListLine(List<IInfoTextLine> l, boolean o) {
        this.textLines = l;
        this.ordered = o;
    }

    @Override
    public IWidget createWidget(IGui gui, IPanel parent) {
        return new PanelList(gui, parent.hasFlag(4));
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        InfoListLine line = new InfoListLine(new ArrayList<IInfoTextLine>(this.textLines.size()), this.ordered);
        for (IInfoTextLine line1 : this.textLines) {
            line.textLines.add(line1.copy(page));
        }
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("list"));
        o.add("ordered", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.ordered)));
        JsonArray a = new JsonArray();
        for (IInfoTextLine line : this.textLines) {
            a.add(line.getJson());
        }
        o.add("list", (JsonElement)a);
        return o;
    }

    private class PanelList
    extends PanelLM {
        private final IGui gui;

        private PanelList(IGui g, boolean unicodeFont) {
            super(0, 0, 0, 0);
            this.gui = g;
            this.addFlags(3);
            if (unicodeFont) {
                this.addFlags(4);
            }
        }

        @Override
        public void addWidgets() {
            for (IInfoTextLine line : InfoListLine.this.textLines) {
                this.add(line.createWidget(this.gui, this));
            }
        }

        @Override
        public void updateWidgetPositions() {
            this.setHeight(this.alignWidgetsByHeight());
        }
    }
}

