/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.IPanel;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class InfoImageLine
extends EmptyInfoPageLine {
    public IImageProvider imageProvider = ImageProvider.NULL;
    public int imageWidth;
    public int imageHeight;
    public double imageScale = 1.0;
    public ClickEvent clickEvent;
    public List<String> hover;

    public InfoImageLine() {
    }

    public InfoImageLine(JsonElement e) {
        this.imageProvider = ImageProvider.NULL;
        this.imageHeight = 0;
        this.imageWidth = 0;
        this.imageScale = 1.0;
        this.hover = null;
        JsonObject o = e.getAsJsonObject();
        if (!o.has("image")) {
            return;
        }
        this.imageProvider = new ImageProvider(new ResourceLocation(o.get("image").getAsString()));
        if (o.has("scale")) {
            this.imageScale = o.get("scale").getAsDouble();
        } else {
            if (o.has("width")) {
                this.imageWidth = o.get("width").getAsInt();
            }
            if (o.has("height")) {
                this.imageHeight = o.get("height").getAsInt();
            }
        }
        if (o.has("click")) {
            // empty if block
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<String>();
            for (JsonElement e1 : o.get("hover").getAsJsonArray()) {
                this.hover.add(LMJsonUtils.deserializeTextComponent(e1).func_150254_d());
            }
        }
    }

    @Override
    public IWidget createWidget(IGui gui, IPanel parent) {
        return new ButtonInfoImage(parent);
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        InfoImageLine line = new InfoImageLine();
        line.imageProvider = this.imageProvider;
        line.imageWidth = this.imageWidth;
        line.imageHeight = this.imageHeight;
        line.imageScale = this.imageScale;
        line.clickEvent = this.clickEvent;
        line.hover = new ArrayList<String>(this.hover);
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("img"));
        o.add("image", (JsonElement)new JsonPrimitive(this.imageProvider.getImage().toString()));
        if (this.imageScale != 1.0) {
            o.add("scale", (JsonElement)new JsonPrimitive((Number)this.imageScale));
        } else if (this.imageWidth != 0 || this.imageHeight != 0) {
            o.add("width", (JsonElement)new JsonPrimitive((Number)this.imageWidth));
            o.add("height", (JsonElement)new JsonPrimitive((Number)this.imageHeight));
        }
        if (this.hover != null) {
            JsonArray a = new JsonArray();
            for (String s : this.hover) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            o.add("hover", (JsonElement)a);
        }
        return o;
    }

    private class ButtonInfoImage
    extends ButtonLM {
        private final IPanel parent;

        private ButtonInfoImage(IPanel p) {
            super(0, 0, 0, 0);
            this.parent = p;
            this.checkSize();
        }

        private void checkSize() {
            InfoImageLine.this.imageProvider.bindTexture();
            int width = this.getWidth();
            int height = this.getHeight();
            if (width == 1 || height == 1) {
                width = Math.max(InfoImageLine.this.imageWidth == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) : InfoImageLine.this.imageWidth, 2);
                height = Math.max(InfoImageLine.this.imageHeight == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) : InfoImageLine.this.imageHeight, 2);
                double w = Math.min((double)this.parent.getWidth(), (double)width * InfoImageLine.this.imageScale);
                double h = (double)height * (w / ((double)width * InfoImageLine.this.imageScale));
                this.setWidth((int)w);
                this.setHeight((int)h);
                this.parent.updateWidgetPositions();
            }
        }

        @Override
        public void renderWidget(IGui gui) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.checkSize();
            InfoImageLine.this.imageProvider.draw(this.getAX(), this.getAY(), this.getWidth(), this.getHeight());
        }

        @Override
        public void addMouseOverText(IGui gui, List<String> list) {
            if (InfoImageLine.this.hover != null) {
                list.addAll(InfoImageLine.this.hover);
            }
        }

        @Override
        public void onClicked(IGui gui, IMouseButton button) {
            if (InfoImageLine.this.clickEvent != null) {
                GuiHelper.playClickSound();
                GuiHelper.onClickEvent(InfoImageLine.this.clickEvent);
            }
        }
    }
}

