/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.EnumDirection;
import com.feed_the_beast.ftbl.lib.gui.WidgetLM;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import java.util.List;
import net.minecraft.util.math.MathHelper;

public class SliderLM
extends WidgetLM {
    public static final IDrawableObject DEFAULT_SLIDER = new TexturelessRectangle(-1721342362);
    public static final IDrawableObject DEFAULT_BACKGROUND = new TexturelessRectangle(-1724697805);
    public final int sliderSize;
    private double value;
    private boolean isGrabbed;
    public IDrawableObject slider = DEFAULT_SLIDER;
    public IDrawableObject background = DEFAULT_BACKGROUND;

    public SliderLM(int x, int y, int w, int h, int ss) {
        super(x, y, w, h);
        this.sliderSize = ss;
    }

    @Override
    public void mousePressed(IGui gui, IMouseButton button) {
        if (gui.isMouseOver(this)) {
            this.setGrabbed(gui, true);
        }
    }

    @Override
    public void addMouseOverText(IGui gui, List<String> list) {
        double max;
        double min = this.getDisplayMin();
        if (min < (max = this.getDisplayMax())) {
            String s = "" + (int)MathHelperLM.map(this.value, 0.0, 1.0, min, max);
            String t = this.getTitle(gui);
            list.add(t.isEmpty() ? s : t + ": " + s);
        }
    }

    @Override
    public void renderWidget(IGui gui) {
        int ax = this.getAX();
        int ay = this.getAY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isEnabled(gui)) {
            double v;
            double v0 = v = this.getValue(gui);
            if (this.isGrabbed(gui)) {
                if (gui.isMouseButtonDown(0)) {
                    v = this.getDirection().isVertical() ? ((double)gui.getMouseY() - ((double)ay + (double)this.sliderSize / 2.0)) / (double)(h - this.sliderSize) : ((double)gui.getMouseX() - ((double)ax + (double)this.sliderSize / 2.0)) / (double)(w - this.sliderSize);
                } else {
                    this.setGrabbed(gui, false);
                }
            }
            if (gui.getMouseWheel() != 0 && this.canMouseScroll(gui)) {
                v += gui.getMouseWheel() < 0 ? this.getScrollStep() : -this.getScrollStep();
            }
            if (v0 != (v = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0))) {
                this.setValue(gui, v);
            }
        }
        this.background.draw(ax, ay, w, h);
        if (this.getDirection().isVertical()) {
            this.slider.draw(ax, ay + this.getValueI(gui, h), w, this.sliderSize);
        } else {
            this.slider.draw(ax + this.getValueI(gui, w), ay, this.sliderSize, h);
        }
    }

    public boolean isGrabbed(IGui gui) {
        return this.isGrabbed;
    }

    public void setGrabbed(IGui gui, boolean b) {
        this.isGrabbed = b;
    }

    public void onMoved(IGui gui) {
    }

    public boolean canMouseScroll(IGui gui) {
        return gui.isMouseOver(this);
    }

    public void setValue(IGui gui, double v) {
        if (this.value != v) {
            this.value = MathHelper.func_151237_a((double)v, (double)0.0, (double)1.0);
            this.onMoved(gui);
        }
    }

    public double getValue(IGui gui) {
        return this.value;
    }

    public int getValueI(IGui gui, int max) {
        return (int)(this.getValue(gui) * (double)(max - this.sliderSize));
    }

    public double getScrollStep() {
        return 0.1;
    }

    public EnumDirection getDirection() {
        return EnumDirection.VERTICAL;
    }

    public double getDisplayMin() {
        return 0.0;
    }

    public double getDisplayMax() {
        return 0.0;
    }
}

