/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.IPanel;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.WidgetLM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class PanelLM
extends WidgetLM
implements IPanel {
    private final List<IWidget> widgets = new ArrayList<IWidget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int flags = 0;

    public PanelLM(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public void addFlags(int f) {
        this.flags |= f;
    }

    @Override
    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public Collection<IWidget> getWidgets() {
        return this.widgets;
    }

    public abstract void addWidgets();

    @Override
    public void refreshWidgets() {
        this.getWidgets().clear();
        this.addWidgets();
        this.updateWidgetPositions();
    }

    protected int alignWidgetsByHeight() {
        return this.alignWidgetsByHeight(0, 0, 0);
    }

    protected int alignWidgetsByHeight(int pre, int spacing, int post) {
        int i = pre;
        for (IWidget widget : this.getWidgets()) {
            widget.setY(i);
            i += widget.getHeight() + spacing;
        }
        if (!this.getWidgets().isEmpty()) {
            i -= spacing;
        }
        return i + post;
    }

    @Override
    public int getAX() {
        return super.getAX() + this.offsetX;
    }

    @Override
    public int getAY() {
        return super.getAY() + this.offsetY;
    }

    protected void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    @Override
    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    @Override
    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    @Override
    public void renderWidget(IGui gui) {
        boolean renderInside = this.hasFlag(1);
        boolean useUnicodeFont = this.hasFlag(4);
        boolean unicode = gui.getFont().func_82883_a();
        gui.getFont().func_78264_a(useUnicodeFont);
        int ax = this.getAX();
        int ay = this.getAY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (renderInside) {
            GuiHelper.pushScissor(gui.getScreen(), ax, ay, w, h);
        }
        this.setOffset(true);
        for (IWidget widget : this.getWidgets()) {
            if (!widget.shouldRender(gui) || renderInside && !widget.collidesWith(ax, ay, w, h)) continue;
            widget.renderWidget(gui);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor();
        }
        gui.getFont().func_78264_a(unicode);
    }

    @Override
    public void addMouseOverText(IGui gui, List<String> list) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (IWidget w : this.getWidgets()) {
            if (!w.isEnabled(gui) || !gui.isMouseOver(w)) continue;
            w.addMouseOverText(gui, list);
        }
        this.setOffset(false);
    }

    @Override
    public void mousePressed(IGui gui, IMouseButton button) {
        if (this.hasFlag(2) && !gui.isMouseOver(this)) {
            return;
        }
        this.setOffset(true);
        for (IWidget w : this.getWidgets()) {
            if (!w.isEnabled(gui)) continue;
            w.mousePressed(gui, button);
        }
        this.setOffset(false);
    }

    @Override
    public void mouseReleased(IGui gui) {
        this.setOffset(true);
        for (IWidget w : this.getWidgets()) {
            if (!w.isEnabled(gui)) continue;
            w.mouseReleased(gui);
        }
        this.setOffset(false);
    }

    @Override
    public boolean keyPressed(IGui gui, int key, char keyChar) {
        this.setOffset(true);
        for (IWidget w : this.getWidgets()) {
            if (!w.isEnabled(gui) || !w.keyPressed(gui, key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }
}

