/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.client.DrawableItem;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemListButtonLM
extends ButtonLM {
    private final DrawableItem item;
    private final int cols;

    public ItemListButtonLM(int x, int y, DrawableItem i, int c) {
        super(x, y, 16, 16);
        this.item = i;
        this.cols = c;
        this.setWidth(this.cols == 0 ? 16 : 4 + Math.min(this.cols, i.getItemCount()) * 16);
        this.setHeight(this.cols == 0 ? 16 : 4 + (i.getItemCount() / this.cols + 1) * 16);
    }

    @Override
    public void renderWidget(IGui gui) {
        int ax = this.getAX();
        int ay = this.getAY();
        if (this.cols == 0) {
            this.item.draw(ax, ay, 16, 16);
        } else {
            for (int i = this.item.getItemCount() - 1; i >= 0; --i) {
                this.item.setIndex(i);
                this.item.draw(ax + 2 + i % this.cols * 16, ay + 2 + i / this.cols * 16, 16, 16);
            }
        }
    }

    @Override
    public void addMouseOverText(IGui gui, List<String> list) {
        ItemStack stack;
        int index = -1;
        if (this.cols > 0) {
            int mx = gui.getMouseX() - this.getAX() - 2;
            int my = gui.getMouseY() - this.getAY() - 2;
            if (mx < 0 || my < 0 || mx >= this.getWidth() - 4 || my >= this.getHeight() - 4) {
                return;
            }
            index = mx / 16 % this.cols + my / 16 * this.cols;
        }
        if ((stack = this.item.getStack(index)) != null) {
            list.add(stack.func_82833_r());
            stack.func_77973_b().func_77624_a(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, list, false);
        }
    }

    @Override
    public void onClicked(IGui gui, IMouseButton button) {
    }
}

