/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.lib.client.SpriteSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelBuilder {
    private static final FaceBakery BAKERY = new FaceBakery();
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORM_MAP;
    private List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private ModelRotation rotation;

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    public ModelBuilder(ModelRotation r) {
        this.rotation = r;
    }

    public void setRotation(ModelRotation r) {
        this.rotation = r;
    }

    public List<BakedQuad> getQuads() {
        return new ArrayList<BakedQuad>(this.quads);
    }

    public void addCube(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, SpriteSet sprites) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addQuad(fromX, fromY, fromZ, toX, toY, toZ, facing, sprites.get(facing));
        }
    }

    public void addInvertedCube(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, SpriteSet sprites) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addQuad(toX, toY, toZ, fromX, fromY, fromZ, facing, sprites.get(facing));
        }
    }

    public static float[] getUV(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, EnumFacing face) {
        switch (face) {
            case DOWN: 
            case UP: {
                return new float[]{fromX, fromZ, toX, toZ};
            }
            case NORTH: 
            case SOUTH: {
                return new float[]{fromX, fromY, toX, toY};
            }
            case EAST: 
            case WEST: {
                return new float[]{fromZ, fromY, toZ, toY};
            }
        }
        return new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    }

    public void addQuad(float fromX, float fromY, float fromZ, float toX, float toY, float toZ, EnumFacing face, @Nullable TextureAtlasSprite sprite) {
        if (sprite != null) {
            float[] uv = ModelBuilder.getUV(fromX, fromY, fromZ, toX, toY, toZ, face);
            this.quads.add(BAKERY.func_178414_a(new org.lwjgl.util.vector.Vector3f(fromX, fromY, fromZ), new org.lwjgl.util.vector.Vector3f(toX, toY, toZ), new BlockPartFace(face, -1, "", new BlockFaceUV(uv, 0)), sprite, face, this.rotation, null, false, true));
        }
    }

    static {
        TRSRTransformation thirdperson = ModelBuilder.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelBuilder.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelBuilder.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ModelBuilder.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)thirdperson)).compose(flipX)));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelBuilder.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelBuilder.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        TRANSFORM_MAP = Maps.immutableEnumMap((Map)builder.build());
    }
}

