/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.google.common.base.Objects;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageProvider
implements IImageProvider {
    public static final ImageProvider NULL = new ImageProvider(new ResourceLocation("textures/misc/unknown_pack.png")){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(int x, int y, int w, int h) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(IWidget widget) {
        }
    };
    private final ResourceLocation texture;
    private final String url;

    public ImageProvider(ResourceLocation tex) {
        this.texture = tex;
        this.url = this.texture.func_110624_b().equals("http") || this.texture.func_110624_b().equals("https") ? this.texture.toString() : "";
    }

    @Override
    public boolean isURL() {
        return this.url.length() > 0;
    }

    @Override
    public final ResourceLocation getImage() {
        return this.texture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITextureObject bindTexture() {
        if (this.isURL()) {
            ITextureObject obj = FTBLibClient.getDownloadImage(this.texture, this.url, NULL.getImage(), null);
            GlStateManager.func_179144_i((int)obj.func_110552_b());
            return obj;
        }
        return FTBLibClient.bindTexture(this.texture);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITextureObject) {
            IImageProvider img = (IImageProvider)o;
            return this.texture.equals((Object)img.getImage()) && this.getMinU() == img.getMinU() && this.getMinV() == img.getMinV() && this.getMaxU() == img.getMaxU() && this.getMaxV() == img.getMaxV();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.getMinU(), this.getMinV(), this.getMaxU(), this.getMaxV()});
    }

    public String toString() {
        return Double.toString(this.getMinU()) + ',' + this.getMinV() + ',' + this.getMaxU() + ',' + this.getMaxV();
    }
}

