/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.ISidebarButton;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public abstract class SidebarButton
extends FinalIDObject
implements ISidebarButton {
    private final IDrawableObject icon;
    private final IConfigValue config;
    private Map<String, Boolean> deps;

    public SidebarButton(ResourceLocation id, IDrawableObject c, @Nullable IConfigValue b, String dependencies) {
        super(id.toString().replace(':', '.'));
        this.icon = c;
        this.config = b;
        if (!dependencies.isEmpty()) {
            this.deps = new HashMap<String, Boolean>();
            block8: for (String s : dependencies.split(";")) {
                int index = s.indexOf(58);
                if (index == -1) continue;
                switch (s.substring(0, index)) {
                    case "before": {
                        this.deps.put(s.substring(index + 1, s.length()), true);
                        continue block8;
                    }
                    case "after": {
                        this.deps.put(s.substring(index + 1, s.length()), false);
                    }
                }
            }
        }
        if (this.deps == null || this.deps.isEmpty()) {
            this.deps = Collections.emptyMap();
        }
    }

    @Override
    public IDrawableObject getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public IConfigValue getConfig() {
        return this.config;
    }

    @Override
    public void render(int ax, int ay) {
        this.icon.draw(ax, ay, 16, 16);
    }

    @Override
    public Map<String, Boolean> getDependencies() {
        return this.deps;
    }

    public static class Dummy
    extends SidebarButton {
        public Dummy(ResourceLocation id) {
            super(id, ImageProvider.NULL, null, "");
        }

        @Override
        public void onClicked(IMouseButton button) {
        }
    }
}

